/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.legacygraphqlapi;

import java.time.Instant;
import java.util.Locale;
import org.opentripplanner.ext.legacygraphqlapi.generated.LegacyGraphQLTypes;
import org.opentripplanner.framework.i18n.I18NString;
import org.opentripplanner.routing.api.response.InputField;
import org.opentripplanner.routing.api.response.RoutingErrorCode;
import org.opentripplanner.routing.graphfinder.PlaceType;
import org.opentripplanner.street.model.RentalFormFactor;
import org.opentripplanner.transit.model.basic.Accessibility;
import org.opentripplanner.transit.model.basic.TransitMode;

public class LegacyGraphQLUtils {
    public static LegacyGraphQLTypes.LegacyGraphQLWheelchairBoarding toGraphQL(Accessibility boarding) {
        if (boarding == null) {
            return null;
        }
        return switch (boarding) {
            default -> throw new IncompatibleClassChangeError();
            case Accessibility.NO_INFORMATION -> LegacyGraphQLTypes.LegacyGraphQLWheelchairBoarding.NO_INFORMATION;
            case Accessibility.POSSIBLE -> LegacyGraphQLTypes.LegacyGraphQLWheelchairBoarding.POSSIBLE;
            case Accessibility.NOT_POSSIBLE -> LegacyGraphQLTypes.LegacyGraphQLWheelchairBoarding.NOT_POSSIBLE;
        };
    }

    public static LegacyGraphQLTypes.LegacyGraphQLRoutingErrorCode toGraphQL(RoutingErrorCode code) {
        if (code == null) {
            return null;
        }
        return switch (code) {
            default -> throw new IncompatibleClassChangeError();
            case RoutingErrorCode.LOCATION_NOT_FOUND -> LegacyGraphQLTypes.LegacyGraphQLRoutingErrorCode.LOCATION_NOT_FOUND;
            case RoutingErrorCode.NO_STOPS_IN_RANGE -> LegacyGraphQLTypes.LegacyGraphQLRoutingErrorCode.NO_STOPS_IN_RANGE;
            case RoutingErrorCode.NO_TRANSIT_CONNECTION -> LegacyGraphQLTypes.LegacyGraphQLRoutingErrorCode.NO_TRANSIT_CONNECTION;
            case RoutingErrorCode.NO_TRANSIT_CONNECTION_IN_SEARCH_WINDOW -> LegacyGraphQLTypes.LegacyGraphQLRoutingErrorCode.NO_TRANSIT_CONNECTION_IN_SEARCH_WINDOW;
            case RoutingErrorCode.OUTSIDE_BOUNDS -> LegacyGraphQLTypes.LegacyGraphQLRoutingErrorCode.OUTSIDE_BOUNDS;
            case RoutingErrorCode.OUTSIDE_SERVICE_PERIOD -> LegacyGraphQLTypes.LegacyGraphQLRoutingErrorCode.OUTSIDE_SERVICE_PERIOD;
            case RoutingErrorCode.SYSTEM_ERROR -> LegacyGraphQLTypes.LegacyGraphQLRoutingErrorCode.SYSTEM_ERROR;
            case RoutingErrorCode.WALKING_BETTER_THAN_TRANSIT -> LegacyGraphQLTypes.LegacyGraphQLRoutingErrorCode.WALKING_BETTER_THAN_TRANSIT;
        };
    }

    public static LegacyGraphQLTypes.LegacyGraphQLInputField toGraphQL(InputField inputField) {
        if (inputField == null) {
            return null;
        }
        return switch (inputField) {
            default -> throw new IncompatibleClassChangeError();
            case InputField.DATE_TIME -> LegacyGraphQLTypes.LegacyGraphQLInputField.DATE_TIME;
            case InputField.FROM_PLACE -> LegacyGraphQLTypes.LegacyGraphQLInputField.FROM;
            case InputField.TO_PLACE, InputField.INTERMEDIATE_PLACE -> LegacyGraphQLTypes.LegacyGraphQLInputField.TO;
        };
    }

    public static LegacyGraphQLTypes.LegacyGraphQLTransitMode toGraphQL(TransitMode mode) {
        if (mode == null) {
            return null;
        }
        return switch (mode) {
            default -> throw new IncompatibleClassChangeError();
            case TransitMode.RAIL -> LegacyGraphQLTypes.LegacyGraphQLTransitMode.RAIL;
            case TransitMode.COACH -> LegacyGraphQLTypes.LegacyGraphQLTransitMode.COACH;
            case TransitMode.SUBWAY -> LegacyGraphQLTypes.LegacyGraphQLTransitMode.SUBWAY;
            case TransitMode.BUS -> LegacyGraphQLTypes.LegacyGraphQLTransitMode.BUS;
            case TransitMode.TRAM -> LegacyGraphQLTypes.LegacyGraphQLTransitMode.TRAM;
            case TransitMode.FERRY -> LegacyGraphQLTypes.LegacyGraphQLTransitMode.FERRY;
            case TransitMode.AIRPLANE -> LegacyGraphQLTypes.LegacyGraphQLTransitMode.AIRPLANE;
            case TransitMode.CABLE_CAR -> LegacyGraphQLTypes.LegacyGraphQLTransitMode.CABLE_CAR;
            case TransitMode.GONDOLA -> LegacyGraphQLTypes.LegacyGraphQLTransitMode.GONDOLA;
            case TransitMode.FUNICULAR -> LegacyGraphQLTypes.LegacyGraphQLTransitMode.FUNICULAR;
            case TransitMode.TROLLEYBUS -> LegacyGraphQLTypes.LegacyGraphQLTransitMode.TROLLEYBUS;
            case TransitMode.MONORAIL -> LegacyGraphQLTypes.LegacyGraphQLTransitMode.MONORAIL;
            case TransitMode.CARPOOL -> LegacyGraphQLTypes.LegacyGraphQLTransitMode.CARPOOL;
            case TransitMode.TAXI -> LegacyGraphQLTypes.LegacyGraphQLTransitMode.TAXI;
        };
    }

    public static RentalFormFactor toModel(LegacyGraphQLTypes.LegacyGraphQLFormFactor formFactor) {
        if (formFactor == null) {
            return null;
        }
        return switch (formFactor) {
            default -> throw new IncompatibleClassChangeError();
            case LegacyGraphQLTypes.LegacyGraphQLFormFactor.BICYCLE -> RentalFormFactor.BICYCLE;
            case LegacyGraphQLTypes.LegacyGraphQLFormFactor.SCOOTER -> RentalFormFactor.SCOOTER;
            case LegacyGraphQLTypes.LegacyGraphQLFormFactor.CAR -> RentalFormFactor.CAR;
            case LegacyGraphQLTypes.LegacyGraphQLFormFactor.CARGO_BICYCLE -> RentalFormFactor.CARGO_BICYCLE;
            case LegacyGraphQLTypes.LegacyGraphQLFormFactor.MOPED -> RentalFormFactor.MOPED;
            case LegacyGraphQLTypes.LegacyGraphQLFormFactor.OTHER -> RentalFormFactor.OTHER;
            case LegacyGraphQLTypes.LegacyGraphQLFormFactor.SCOOTER_SEATED -> RentalFormFactor.SCOOTER_SEATED;
            case LegacyGraphQLTypes.LegacyGraphQLFormFactor.SCOOTER_STANDING -> RentalFormFactor.SCOOTER_STANDING;
        };
    }

    public static PlaceType toModel(LegacyGraphQLTypes.LegacyGraphQLFilterPlaceType type) {
        if (type == null) {
            return null;
        }
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case LegacyGraphQLTypes.LegacyGraphQLFilterPlaceType.BICYCLE_RENT, LegacyGraphQLTypes.LegacyGraphQLFilterPlaceType.VEHICLE_RENT -> PlaceType.VEHICLE_RENT;
            case LegacyGraphQLTypes.LegacyGraphQLFilterPlaceType.BIKE_PARK -> PlaceType.BIKE_PARK;
            case LegacyGraphQLTypes.LegacyGraphQLFilterPlaceType.CAR_PARK -> PlaceType.CAR_PARK;
            case LegacyGraphQLTypes.LegacyGraphQLFilterPlaceType.DEPARTURE_ROW -> PlaceType.PATTERN_AT_STOP;
            case LegacyGraphQLTypes.LegacyGraphQLFilterPlaceType.STOP -> PlaceType.STOP;
        };
    }

    public static Instant getTimeOrNow(long epochSeconds) {
        return epochSeconds != 0L ? Instant.ofEpochSecond(epochSeconds) : Instant.now();
    }

    public static boolean startsWith(String str, String name, Locale locale) {
        return str != null && str.toLowerCase(locale).startsWith(name);
    }

    public static boolean startsWith(I18NString str, String name, Locale locale) {
        return str != null && str.toString(locale).toLowerCase(locale).startsWith(name);
    }
}

