/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.interactivelauncher.views;

import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import org.opentripplanner.ext.interactivelauncher.Model;
import org.opentripplanner.ext.interactivelauncher.views.ViewUtils;

class OptionsView {
    private final Box panel = Box.createVerticalBox();
    private final JCheckBox buildStreetGraphChk;
    private final JCheckBox buildTransitGraphChk;
    private final JCheckBox saveGraphChk;
    private final JCheckBox startOptServerChk;
    private final JCheckBox startOptVisualizerChk;
    private final Model model;

    OptionsView(Model model) {
        this.model = model;
        this.buildStreetGraphChk = new JCheckBox("Street graph", model.isBuildStreet());
        this.buildTransitGraphChk = new JCheckBox("Transit graph", model.isBuildTransit());
        this.saveGraphChk = new JCheckBox("Save graph", model.isSaveGraph());
        this.startOptServerChk = new JCheckBox("Serve graph", model.isServeGraph());
        this.startOptVisualizerChk = new JCheckBox("Visualizer", model.isVisualizer());
        ViewUtils.addComp(new JLabel("Build graph"), this.panel);
        ViewUtils.addSectionSpace(this.panel);
        ViewUtils.addComp(this.buildStreetGraphChk, this.panel);
        ViewUtils.addComp(this.buildTransitGraphChk, this.panel);
        ViewUtils.addSectionDoubleSpace(this.panel);
        this.buildStreetGraphChk.addActionListener(e -> this.onBuildGraphChkChanged());
        this.buildTransitGraphChk.addActionListener(e -> this.onBuildGraphChkChanged());
        this.startOptServerChk.addActionListener(e -> this.onStartOptServerChkChanged());
        ViewUtils.addComp(new JLabel("Actions"), this.panel);
        ViewUtils.addSectionSpace(this.panel);
        ViewUtils.addComp(this.saveGraphChk, this.panel);
        ViewUtils.addComp(this.startOptServerChk, this.panel);
        ViewUtils.addComp(this.startOptVisualizerChk, this.panel);
        this.addDebugCheckBoxes(model);
        ViewUtils.addSectionDoubleSpace(this.panel);
        this.bindCheckBoxesToModel();
    }

    Box panel() {
        return this.panel;
    }

    void initState() {
        this.onBuildGraphChkChanged();
    }

    void bind(JCheckBox box, Consumer<Boolean> modelUpdate) {
        box.addActionListener(l -> modelUpdate.accept(box.isSelected() && box.isEnabled()));
    }

    private void addDebugCheckBoxes(Model model) {
        ViewUtils.addSectionSpace(this.panel);
        ViewUtils.addComp(new JLabel("Debug logging"), this.panel);
        ViewUtils.addSectionSpace(this.panel);
        Map<String, Boolean> entries = model.getDebugLogging();
        List keys = entries.keySet().stream().sorted().collect(Collectors.toList());
        for (String name : keys) {
            JCheckBox box = new JCheckBox(name, (boolean)entries.get(name));
            box.addActionListener(l -> model.getDebugLogging().put(name, box.isSelected()));
            ViewUtils.addComp(box, this.panel);
        }
    }

    private void bindCheckBoxesToModel() {
        this.bind(this.buildStreetGraphChk, this.model::setBuildStreet);
        this.bind(this.buildTransitGraphChk, this.model::setBuildTransit);
        this.bind(this.saveGraphChk, this.model::setSaveGraph);
        this.bind(this.startOptServerChk, this.model::setServeGraph);
        this.bind(this.startOptVisualizerChk, this.model::setVisualizer);
    }

    private boolean buildStreet() {
        return this.buildStreetGraphChk.isSelected();
    }

    private boolean buildTransit() {
        return this.buildTransitGraphChk.isSelected();
    }

    private void onBuildGraphChkChanged() {
        this.saveGraphChk.setEnabled(this.buildStreet() || this.buildTransit());
        this.startOptServerChk.setEnabled(this.buildTransit() || !this.buildStreet());
        this.startOptVisualizerChk.setEnabled(this.buildTransit() || !this.buildStreet());
    }

    private void onStartOptServerChkChanged() {
        this.startOptVisualizerChk.setEnabled(this.startOptServerChk.isEnabled() && this.startOptServerChk.isSelected());
    }
}

