/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.interactivelauncher.views;

import java.awt.event.ActionEvent;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import org.opentripplanner.ext.interactivelauncher.Model;
import org.opentripplanner.ext.interactivelauncher.views.ViewUtils;

class DataSourcesView {
    private final Box panel = Box.createVerticalBox();
    private final Box dataSourceSelectionPanel = Box.createVerticalBox();
    private final Model model;

    public DataSourcesView(Model model) {
        this.model = model;
        this.setupDataSources();
        ViewUtils.addComp(new JLabel("Select data source"), this.panel);
        ViewUtils.addSectionSpace(this.panel);
        ViewUtils.addComp(this.dataSourceSelectionPanel, this.panel);
        ViewUtils.addSectionDoubleSpace(this.panel);
    }

    public Box panel() {
        return this.panel;
    }

    public void onRootDirChange() {
        this.model.setDataSource(null);
        this.dataSourceSelectionPanel.removeAll();
        this.setupDataSources();
        this.panel.repaint();
    }

    public void onDataSourceChange(ActionEvent e) {
        this.model.setDataSource(e.getActionCommand());
    }

    private static JRadioButton newRadioBtn(ButtonGroup group, String name, boolean selected) {
        JRadioButton radioButton = new JRadioButton(name, selected);
        group.add(radioButton);
        return radioButton;
    }

    private void setupDataSources() {
        List<String> values = this.model.getDataSourceOptions();
        if (values.isEmpty()) {
            this.model.setDataSource(null);
            JLabel label = new JLabel("<No otp configuration files found>");
            label.setBackground(ViewUtils.BG_STATUS_BAR);
            label.setForeground(ViewUtils.FG_STATUS_BAR);
            ViewUtils.addComp(label, this.dataSourceSelectionPanel);
            return;
        }
        String selectedValue = this.model.getDataSource();
        if (selectedValue == null) {
            selectedValue = values.get(0);
            this.model.setDataSource(selectedValue);
        }
        ButtonGroup selectDataSourceRadioGroup = new ButtonGroup();
        List valuesSorted = values.stream().sorted().collect(Collectors.toList());
        for (String name : valuesSorted) {
            boolean selected = selectedValue.equals(name);
            JRadioButton radioBtn = DataSourcesView.newRadioBtn(selectDataSourceRadioGroup, name, selected);
            radioBtn.addActionListener(this::onDataSourceChange);
            ViewUtils.addComp(radioBtn, this.dataSourceSelectionPanel);
        }
    }
}

