/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.flex.trip;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.opentripplanner.ext.flex.FlexServiceDate;
import org.opentripplanner.ext.flex.flexpathcalculator.FlexPathCalculator;
import org.opentripplanner.ext.flex.template.FlexAccessTemplate;
import org.opentripplanner.ext.flex.template.FlexEgressTemplate;
import org.opentripplanner.ext.flex.trip.FlexTrip;
import org.opentripplanner.ext.flex.trip.UnscheduledTripBuilder;
import org.opentripplanner.model.BookingInfo;
import org.opentripplanner.model.PickDrop;
import org.opentripplanner.model.StopTime;
import org.opentripplanner.routing.graphfinder.NearbyStop;
import org.opentripplanner.standalone.config.sandbox.FlexConfig;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.framework.TransitBuilder;
import org.opentripplanner.transit.model.site.GroupStop;
import org.opentripplanner.transit.model.site.StopLocation;

public class UnscheduledTrip
extends FlexTrip<UnscheduledTrip, UnscheduledTripBuilder> {
    private static final Set<Integer> N_STOPS = Set.of(Integer.valueOf(1), Integer.valueOf(2));
    private final UnscheduledStopTime[] stopTimes;
    private final BookingInfo[] dropOffBookingInfos;
    private final BookingInfo[] pickupBookingInfos;

    public UnscheduledTrip(UnscheduledTripBuilder builder) {
        super(builder);
        List<StopTime> stopTimes = builder.stopTimes();
        if (!UnscheduledTrip.isUnscheduledTrip(stopTimes)) {
            throw new IllegalArgumentException("Incompatible stopTimes for unscheduled trip");
        }
        int size = stopTimes.size();
        this.stopTimes = new UnscheduledStopTime[size];
        this.dropOffBookingInfos = new BookingInfo[size];
        this.pickupBookingInfos = new BookingInfo[size];
        for (int i = 0; i < size; ++i) {
            this.stopTimes[i] = new UnscheduledStopTime(stopTimes.get(i));
            this.dropOffBookingInfos[i] = stopTimes.get(0).getDropOffBookingInfo();
            this.pickupBookingInfos[i] = stopTimes.get(0).getPickupBookingInfo();
        }
    }

    public static UnscheduledTripBuilder of(FeedScopedId id) {
        return new UnscheduledTripBuilder(id);
    }

    public static boolean isUnscheduledTrip(List<StopTime> stopTimes) {
        Predicate<StopTime> hasFlexWindow = st -> st.getFlexWindowStart() != -999 || st.getFlexWindowEnd() != -999;
        Predicate<StopTime> notContinuousStop = stopTime -> stopTime.getFlexContinuousDropOff() == PickDrop.NONE && stopTime.getFlexContinuousPickup() == PickDrop.NONE;
        return N_STOPS.contains(stopTimes.size()) && stopTimes.stream().anyMatch(hasFlexWindow) && stopTimes.stream().allMatch(notContinuousStop);
    }

    @Override
    public Stream<FlexAccessTemplate> getFlexAccessTemplates(NearbyStop access, FlexServiceDate date, FlexPathCalculator calculator, FlexConfig config) {
        int fromIndex = this.getFromIndex(access);
        int toIndex = this.stopTimes.length - 1;
        if (fromIndex == -1 || fromIndex > toIndex || this.getDropOffType(toIndex).isNotRoutable()) {
            return Stream.empty();
        }
        ArrayList<FlexAccessTemplate> res = new ArrayList<FlexAccessTemplate>();
        for (StopLocation stop : this.expandStops(this.stopTimes[toIndex].stop)) {
            res.add(new FlexAccessTemplate(access, this, fromIndex, toIndex, stop, date, calculator, config));
        }
        return res.stream();
    }

    @Override
    public Stream<FlexEgressTemplate> getFlexEgressTemplates(NearbyStop egress, FlexServiceDate date, FlexPathCalculator calculator, FlexConfig config) {
        int fromIndex = 0;
        int toIndex = this.getToIndex(egress);
        if (toIndex == -1 || fromIndex > toIndex || this.getPickupType(fromIndex).isNotRoutable()) {
            return Stream.empty();
        }
        ArrayList<FlexEgressTemplate> res = new ArrayList<FlexEgressTemplate>();
        for (StopLocation stop : this.expandStops(this.stopTimes[fromIndex].stop)) {
            res.add(new FlexEgressTemplate(egress, this, fromIndex, toIndex, stop, date, calculator, config));
        }
        return res.stream();
    }

    @Override
    public int earliestDepartureTime(int requestedDepartureTime, int fromStopIndex, int toStopIndex, int flexTime) {
        UnscheduledStopTime fromStopTime = this.stopTimes[fromStopIndex];
        UnscheduledStopTime toStopTime = this.stopTimes[toStopIndex];
        int earliestDepartureTime = Math.max(requestedDepartureTime, fromStopTime.flexWindowStart);
        if (fromStopTime.flexWindowEnd < earliestDepartureTime || toStopTime.flexWindowEnd < earliestDepartureTime + flexTime) {
            return -999;
        }
        return earliestDepartureTime;
    }

    @Override
    public int earliestDepartureTime(int stopIndex) {
        return this.stopTimes[stopIndex].flexWindowStart;
    }

    @Override
    public int latestArrivalTime(int arrivalTime, int fromStopIndex, int toStopIndex, int flexTime) {
        UnscheduledStopTime fromStopTime = this.stopTimes[fromStopIndex];
        UnscheduledStopTime toStopTime = this.stopTimes[toStopIndex];
        int latestArrivalTime = Math.min(arrivalTime, toStopTime.flexWindowEnd);
        if (toStopTime.flexWindowStart > latestArrivalTime || fromStopTime.flexWindowStart > latestArrivalTime - flexTime) {
            return -999;
        }
        return latestArrivalTime;
    }

    @Override
    public int latestArrivalTime(int stopIndex) {
        return this.stopTimes[stopIndex].flexWindowEnd;
    }

    @Override
    public Set<StopLocation> getStops() {
        return Arrays.stream(this.stopTimes).map(scheduledDeviatedStopTime -> scheduledDeviatedStopTime.stop).collect(Collectors.toSet());
    }

    @Override
    public BookingInfo getDropOffBookingInfo(int i) {
        return this.dropOffBookingInfos[i];
    }

    @Override
    public BookingInfo getPickupBookingInfo(int i) {
        return this.pickupBookingInfos[i];
    }

    @Override
    public PickDrop getBoardRule(int i) {
        return this.stopTimes[i].pickupType;
    }

    @Override
    public PickDrop getAlightRule(int i) {
        return this.stopTimes[i].dropOffType;
    }

    @Override
    public boolean isBoardingPossible(NearbyStop stop) {
        return this.getFromIndex(stop) != -1;
    }

    @Override
    public boolean isAlightingPossible(NearbyStop stop) {
        return this.getToIndex(stop) != -1;
    }

    public PickDrop getPickupType(int i) {
        return this.stopTimes[i].pickupType;
    }

    public PickDrop getDropOffType(int i) {
        return this.stopTimes[i].dropOffType;
    }

    @Override
    public boolean sameAs(@Nonnull UnscheduledTrip other) {
        return super.sameAs(other) && Arrays.equals(this.stopTimes, other.stopTimes) && Arrays.equals(this.pickupBookingInfos, other.pickupBookingInfos) && Arrays.equals(this.dropOffBookingInfos, other.dropOffBookingInfos);
    }

    @Override
    @Nonnull
    public TransitBuilder<UnscheduledTrip, UnscheduledTripBuilder> copy() {
        return new UnscheduledTripBuilder(this);
    }

    private Collection<StopLocation> expandStops(StopLocation stop) {
        Set<StopLocation> set;
        if (stop instanceof GroupStop) {
            GroupStop groupStop = (GroupStop)stop;
            set = groupStop.getLocations();
        } else {
            set = Collections.singleton(stop);
        }
        return set;
    }

    private int getFromIndex(NearbyStop accessEgress) {
        for (int i = 0; i < this.stopTimes.length; ++i) {
            GroupStop groupStop;
            StopLocation stop;
            if (this.getPickupType(i).isNotRoutable() || !((stop = this.stopTimes[i].stop) instanceof GroupStop ? (groupStop = (GroupStop)stop).getLocations().contains(accessEgress.stop) : stop.equals(accessEgress.stop))) continue;
            return i;
        }
        return -1;
    }

    private int getToIndex(NearbyStop accessEgress) {
        for (int i = this.stopTimes.length - 1; i >= 0; --i) {
            GroupStop groupStop;
            StopLocation stop;
            if (this.getDropOffType(i).isNotRoutable() || !((stop = this.stopTimes[i].stop) instanceof GroupStop ? (groupStop = (GroupStop)stop).getLocations().contains(accessEgress.stop) : stop.equals(accessEgress.stop))) continue;
            return i;
        }
        return -1;
    }

    private static class UnscheduledStopTime
    implements Serializable {
        private final StopLocation stop;
        private final int flexWindowStart;
        private final int flexWindowEnd;
        private final PickDrop pickupType;
        private final PickDrop dropOffType;

        private UnscheduledStopTime(StopTime st) {
            this.stop = st.getStop();
            int earliestPossibleDepartureTime = st.getEarliestPossibleDepartureTime();
            int latestPossibleArrivalTime = st.getLatestPossibleArrivalTime();
            this.flexWindowStart = UnscheduledStopTime.getAvailableTime(earliestPossibleDepartureTime, latestPossibleArrivalTime);
            this.flexWindowEnd = UnscheduledStopTime.getAvailableTime(latestPossibleArrivalTime, earliestPossibleDepartureTime);
            this.pickupType = this.flexWindowStart == -999 ? PickDrop.NONE : st.getPickupType();
            this.dropOffType = this.flexWindowEnd == -999 ? PickDrop.NONE : st.getDropOffType();
        }

        private static int getAvailableTime(int ... times) {
            for (int time : times) {
                if (time == -999) continue;
                return time;
            }
            return -999;
        }
    }
}

