/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.flex.trip;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.opentripplanner.ext.flex.FlexServiceDate;
import org.opentripplanner.ext.flex.flexpathcalculator.FlexPathCalculator;
import org.opentripplanner.ext.flex.flexpathcalculator.ScheduledFlexPathCalculator;
import org.opentripplanner.ext.flex.template.FlexAccessTemplate;
import org.opentripplanner.ext.flex.template.FlexEgressTemplate;
import org.opentripplanner.ext.flex.trip.FlexTrip;
import org.opentripplanner.ext.flex.trip.ScheduledDeviatedTripBuilder;
import org.opentripplanner.model.BookingInfo;
import org.opentripplanner.model.PickDrop;
import org.opentripplanner.model.StopTime;
import org.opentripplanner.routing.graphfinder.NearbyStop;
import org.opentripplanner.standalone.config.sandbox.FlexConfig;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.framework.TransitBuilder;
import org.opentripplanner.transit.model.site.GroupStop;
import org.opentripplanner.transit.model.site.RegularStop;
import org.opentripplanner.transit.model.site.StopLocation;

public class ScheduledDeviatedTrip
extends FlexTrip<ScheduledDeviatedTrip, ScheduledDeviatedTripBuilder> {
    private final ScheduledDeviatedStopTime[] stopTimes;
    private final BookingInfo[] dropOffBookingInfos;
    private final BookingInfo[] pickupBookingInfos;

    ScheduledDeviatedTrip(ScheduledDeviatedTripBuilder builder) {
        super(builder);
        List<StopTime> stopTimes = builder.stopTimes();
        if (!ScheduledDeviatedTrip.isScheduledFlexTrip(stopTimes)) {
            throw new IllegalArgumentException("Incompatible stopTimes for scheduled flex trip");
        }
        int nStops = stopTimes.size();
        this.stopTimes = new ScheduledDeviatedStopTime[nStops];
        this.dropOffBookingInfos = new BookingInfo[nStops];
        this.pickupBookingInfos = new BookingInfo[nStops];
        for (int i = 0; i < nStops; ++i) {
            this.stopTimes[i] = new ScheduledDeviatedStopTime(stopTimes.get(i));
            this.dropOffBookingInfos[i] = stopTimes.get(i).getDropOffBookingInfo();
            this.pickupBookingInfos[i] = stopTimes.get(i).getPickupBookingInfo();
        }
    }

    public static ScheduledDeviatedTripBuilder of(FeedScopedId id) {
        return new ScheduledDeviatedTripBuilder(id);
    }

    public static boolean isScheduledFlexTrip(List<StopTime> stopTimes) {
        Predicate<StopTime> notStopType = Predicate.not(st -> st.getStop() instanceof RegularStop);
        Predicate<StopTime> notContinuousStop = stopTime -> stopTime.getFlexContinuousDropOff() == PickDrop.NONE && stopTime.getFlexContinuousPickup() == PickDrop.NONE;
        return stopTimes.stream().anyMatch(notStopType) && stopTimes.stream().allMatch(notContinuousStop);
    }

    @Override
    public Stream<FlexAccessTemplate> getFlexAccessTemplates(NearbyStop access, FlexServiceDate date, FlexPathCalculator calculator, FlexConfig config) {
        ScheduledFlexPathCalculator scheduledCalculator = new ScheduledFlexPathCalculator(calculator, this);
        int fromIndex = this.getFromIndex(access);
        if (fromIndex == -1) {
            return Stream.empty();
        }
        ArrayList<FlexAccessTemplate> res = new ArrayList<FlexAccessTemplate>();
        for (int toIndex = fromIndex; toIndex < this.stopTimes.length; ++toIndex) {
            if (this.getDropOffType(toIndex).isNotRoutable()) continue;
            for (StopLocation stop : this.expandStops(this.stopTimes[toIndex].stop)) {
                res.add(new FlexAccessTemplate(access, this, fromIndex, toIndex, stop, date, scheduledCalculator, config));
            }
        }
        return res.stream();
    }

    @Override
    public Stream<FlexEgressTemplate> getFlexEgressTemplates(NearbyStop egress, FlexServiceDate date, FlexPathCalculator calculator, FlexConfig config) {
        ScheduledFlexPathCalculator scheduledCalculator = new ScheduledFlexPathCalculator(calculator, this);
        int toIndex = this.getToIndex(egress);
        if (toIndex == -1) {
            return Stream.empty();
        }
        ArrayList<FlexEgressTemplate> res = new ArrayList<FlexEgressTemplate>();
        for (int fromIndex = toIndex; fromIndex >= 0; --fromIndex) {
            if (this.getPickupType(fromIndex).isNotRoutable()) continue;
            for (StopLocation stop : this.expandStops(this.stopTimes[fromIndex].stop)) {
                res.add(new FlexEgressTemplate(egress, this, fromIndex, toIndex, stop, date, scheduledCalculator, config));
            }
        }
        return res.stream();
    }

    @Override
    public int earliestDepartureTime(int departureTime, int fromStopIndex, int toStopIndex, int flexTime) {
        int stopTime = -999;
        for (int i = fromStopIndex; stopTime == -999 && i >= 0; --i) {
            stopTime = this.stopTimes[i].departureTime;
        }
        return stopTime >= departureTime ? stopTime : -999;
    }

    @Override
    public int earliestDepartureTime(int stopIndex) {
        return this.stopTimes[stopIndex].departureTime;
    }

    @Override
    public int latestArrivalTime(int arrivalTime, int fromStopIndex, int toStopIndex, int flexTime) {
        int stopTime = -999;
        for (int i = toStopIndex; stopTime == -999 && i < this.stopTimes.length; ++i) {
            stopTime = this.stopTimes[i].arrivalTime;
        }
        return stopTime <= arrivalTime ? stopTime : -999;
    }

    @Override
    public int latestArrivalTime(int stopIndex) {
        return this.stopTimes[stopIndex].arrivalTime;
    }

    @Override
    public Set<StopLocation> getStops() {
        return Arrays.stream(this.stopTimes).map(scheduledDeviatedStopTime -> scheduledDeviatedStopTime.stop).collect(Collectors.toSet());
    }

    @Override
    public BookingInfo getDropOffBookingInfo(int i) {
        return this.dropOffBookingInfos[i];
    }

    @Override
    public BookingInfo getPickupBookingInfo(int i) {
        return this.pickupBookingInfos[i];
    }

    @Override
    public PickDrop getBoardRule(int i) {
        return this.stopTimes[i].pickupType;
    }

    @Override
    public PickDrop getAlightRule(int i) {
        return this.stopTimes[i].dropOffType;
    }

    @Override
    public boolean isBoardingPossible(NearbyStop stop) {
        return this.getFromIndex(stop) != -1;
    }

    @Override
    public boolean isAlightingPossible(NearbyStop stop) {
        return this.getToIndex(stop) != -1;
    }

    public PickDrop getPickupType(int i) {
        return this.stopTimes[i].pickupType;
    }

    public PickDrop getDropOffType(int i) {
        return this.stopTimes[i].dropOffType;
    }

    @Override
    public boolean sameAs(@Nonnull ScheduledDeviatedTrip other) {
        return super.sameAs(other) && Arrays.equals(this.stopTimes, other.stopTimes) && Arrays.equals(this.pickupBookingInfos, other.pickupBookingInfos) && Arrays.equals(this.dropOffBookingInfos, other.dropOffBookingInfos);
    }

    @Override
    @Nonnull
    public TransitBuilder<ScheduledDeviatedTrip, ScheduledDeviatedTripBuilder> copy() {
        return new ScheduledDeviatedTripBuilder(this);
    }

    private Collection<StopLocation> expandStops(StopLocation stop) {
        Set<StopLocation> set;
        if (stop instanceof GroupStop) {
            GroupStop groupStop = (GroupStop)stop;
            set = groupStop.getLocations();
        } else {
            set = Collections.singleton(stop);
        }
        return set;
    }

    private int getFromIndex(NearbyStop accessEgress) {
        for (int i = 0; i < this.stopTimes.length; ++i) {
            GroupStop groupStop;
            StopLocation stop;
            if (this.getPickupType(i).isNotRoutable() || !((stop = this.stopTimes[i].stop) instanceof GroupStop ? (groupStop = (GroupStop)stop).getLocations().contains(accessEgress.stop) : stop.equals(accessEgress.stop))) continue;
            return i;
        }
        return -1;
    }

    private int getToIndex(NearbyStop accessEgress) {
        for (int i = this.stopTimes.length - 1; i >= 0; --i) {
            GroupStop groupStop;
            StopLocation stop;
            if (this.getDropOffType(i).isNotRoutable() || !((stop = this.stopTimes[i].stop) instanceof GroupStop ? (groupStop = (GroupStop)stop).getLocations().contains(accessEgress.stop) : stop.equals(accessEgress.stop))) continue;
            return i;
        }
        return -1;
    }

    private static class ScheduledDeviatedStopTime
    implements Serializable {
        private final StopLocation stop;
        private final int departureTime;
        private final int arrivalTime;
        private final PickDrop pickupType;
        private final PickDrop dropOffType;

        private ScheduledDeviatedStopTime(StopTime st) {
            this.stop = st.getStop();
            this.arrivalTime = st.getLatestPossibleArrivalTime();
            this.departureTime = st.getEarliestPossibleDepartureTime();
            this.pickupType = this.departureTime == -999 ? PickDrop.NONE : st.getPickupType();
            this.dropOffType = this.arrivalTime == -999 ? PickDrop.NONE : st.getDropOffType();
        }
    }
}

