/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.flex.trip;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.opentripplanner.ext.flex.FlexServiceDate;
import org.opentripplanner.ext.flex.flexpathcalculator.FlexPathCalculator;
import org.opentripplanner.ext.flex.template.FlexAccessTemplate;
import org.opentripplanner.ext.flex.template.FlexEgressTemplate;
import org.opentripplanner.ext.flex.trip.FlexTripBuilder;
import org.opentripplanner.model.BookingInfo;
import org.opentripplanner.model.PickDrop;
import org.opentripplanner.model.StopTime;
import org.opentripplanner.routing.graphfinder.NearbyStop;
import org.opentripplanner.standalone.config.sandbox.FlexConfig;
import org.opentripplanner.transit.model.framework.AbstractTransitEntity;
import org.opentripplanner.transit.model.site.AreaStop;
import org.opentripplanner.transit.model.site.GroupStop;
import org.opentripplanner.transit.model.site.StopLocation;
import org.opentripplanner.transit.model.timetable.Trip;

public abstract class FlexTrip<T extends FlexTrip<T, B>, B extends FlexTripBuilder<T, B>>
extends AbstractTransitEntity<T, B> {
    private final Trip trip;

    FlexTrip(FlexTripBuilder<T, B> builder) {
        super(builder.getId());
        this.trip = builder.trip();
    }

    public static boolean containsFlexStops(List<StopTime> stopTimes) {
        return stopTimes.stream().map(StopTime::getStop).anyMatch(FlexTrip::isFlexStop);
    }

    public static boolean isFlexStop(StopLocation stop) {
        return stop instanceof GroupStop || stop instanceof AreaStop;
    }

    public abstract Stream<FlexAccessTemplate> getFlexAccessTemplates(NearbyStop var1, FlexServiceDate var2, FlexPathCalculator var3, FlexConfig var4);

    public abstract Stream<FlexEgressTemplate> getFlexEgressTemplates(NearbyStop var1, FlexServiceDate var2, FlexPathCalculator var3, FlexConfig var4);

    public abstract int earliestDepartureTime(int var1, int var2, int var3, int var4);

    public abstract int earliestDepartureTime(int var1);

    public abstract int latestArrivalTime(int var1, int var2, int var3, int var4);

    public abstract int latestArrivalTime(int var1);

    public abstract Set<StopLocation> getStops();

    public Trip getTrip() {
        return this.trip;
    }

    public abstract BookingInfo getDropOffBookingInfo(int var1);

    public abstract BookingInfo getPickupBookingInfo(int var1);

    public abstract PickDrop getBoardRule(int var1);

    public abstract PickDrop getAlightRule(int var1);

    public abstract boolean isBoardingPossible(NearbyStop var1);

    public abstract boolean isAlightingPossible(NearbyStop var1);

    @Override
    public boolean sameAs(@Nonnull T other) {
        return this.getId().equals(((AbstractTransitEntity)other).getId()) && Objects.equals(this.trip, ((FlexTrip)other).getTrip());
    }
}

