/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.flex.template;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import org.opentripplanner.ext.flex.FlexServiceDate;
import org.opentripplanner.ext.flex.edgetype.FlexTripEdge;
import org.opentripplanner.ext.flex.flexpathcalculator.FlexPathCalculator;
import org.opentripplanner.ext.flex.template.FlexAccessEgressTemplate;
import org.opentripplanner.ext.flex.trip.FlexTrip;
import org.opentripplanner.model.PathTransfer;
import org.opentripplanner.routing.graphfinder.NearbyStop;
import org.opentripplanner.standalone.config.sandbox.FlexConfig;
import org.opentripplanner.street.model.edge.Edge;
import org.opentripplanner.street.model.vertex.Vertex;
import org.opentripplanner.street.search.state.State;
import org.opentripplanner.transit.model.site.RegularStop;
import org.opentripplanner.transit.model.site.StopLocation;
import org.opentripplanner.transit.service.TransitService;

public class FlexEgressTemplate
extends FlexAccessEgressTemplate {
    public FlexEgressTemplate(NearbyStop accessEgress, FlexTrip trip, int fromStopTime, int toStopTime, StopLocation transferStop, FlexServiceDate date, FlexPathCalculator calculator, FlexConfig config) {
        super(accessEgress, trip, fromStopTime, toStopTime, transferStop, date, calculator, config);
    }

    @Override
    protected List<Edge> getTransferEdges(PathTransfer transfer) {
        return Lists.reverse(transfer.getEdges());
    }

    @Override
    protected RegularStop getFinalStop(PathTransfer transfer) {
        return transfer.from instanceof RegularStop ? (RegularStop)transfer.from : null;
    }

    @Override
    protected Collection<PathTransfer> getTransfersFromTransferStop(TransitService transitService) {
        return transitService.getFlexIndex().getTransfersToStop(this.transferStop);
    }

    @Override
    protected Vertex getFlexVertex(Edge edge) {
        return edge.getToVertex();
    }

    @Override
    protected int[] getFlexTimes(FlexTripEdge flexEdge, State state) {
        int postFlexTime = (int)this.accessEgress.state.getElapsedTimeSeconds();
        int edgeTimeInSeconds = flexEdge.getTimeInSeconds();
        int preFlexTime = (int)state.getElapsedTimeSeconds() - postFlexTime - edgeTimeInSeconds;
        return new int[]{preFlexTime, edgeTimeInSeconds, postFlexTime};
    }

    @Override
    protected FlexTripEdge getFlexEdge(Vertex flexFromVertex, StopLocation transferStop) {
        return new FlexTripEdge(flexFromVertex, this.accessEgress.state.getVertex(), transferStop, this.accessEgress.stop, this.trip, this, this.calculator);
    }

    protected boolean isRouteable(Vertex flexVertex) {
        if (this.accessEgress.state.getVertex() == flexVertex) {
            return false;
        }
        return this.calculator.calculateFlexPath(flexVertex, this.accessEgress.state.getVertex(), this.fromStopIndex, this.toStopIndex) != null;
    }
}

