/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.flex.template;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.opentripplanner.ext.flex.FlexAccessEgress;
import org.opentripplanner.ext.flex.FlexServiceDate;
import org.opentripplanner.ext.flex.edgetype.FlexTripEdge;
import org.opentripplanner.ext.flex.flexpathcalculator.FlexPathCalculator;
import org.opentripplanner.ext.flex.trip.FlexTrip;
import org.opentripplanner.framework.tostring.ToStringBuilder;
import org.opentripplanner.model.PathTransfer;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.routing.graphfinder.NearbyStop;
import org.opentripplanner.standalone.config.sandbox.FlexConfig;
import org.opentripplanner.street.model.edge.Edge;
import org.opentripplanner.street.model.vertex.TransitStopVertex;
import org.opentripplanner.street.model.vertex.Vertex;
import org.opentripplanner.street.search.state.State;
import org.opentripplanner.transit.model.site.RegularStop;
import org.opentripplanner.transit.model.site.StopLocation;
import org.opentripplanner.transit.service.TransitService;

public abstract class FlexAccessEgressTemplate {
    protected final NearbyStop accessEgress;
    protected final FlexTrip trip;
    public final int fromStopIndex;
    public final int toStopIndex;
    protected final StopLocation transferStop;
    protected final int secondsFromStartOfTime;
    public final LocalDate serviceDate;
    protected final FlexPathCalculator calculator;
    private final FlexConfig flexConfig;

    FlexAccessEgressTemplate(NearbyStop accessEgress, FlexTrip trip, int fromStopIndex, int toStopIndex, StopLocation transferStop, FlexServiceDate date, FlexPathCalculator calculator, FlexConfig config) {
        this.accessEgress = accessEgress;
        this.trip = trip;
        this.fromStopIndex = fromStopIndex;
        this.toStopIndex = toStopIndex;
        this.transferStop = transferStop;
        this.secondsFromStartOfTime = date.secondsFromStartOfTime;
        this.serviceDate = date.serviceDate;
        this.calculator = calculator;
        this.flexConfig = config;
    }

    public StopLocation getTransferStop() {
        return this.transferStop;
    }

    public StopLocation getAccessEgressStop() {
        return this.accessEgress.stop;
    }

    public Stream<FlexAccessEgress> createFlexAccessEgressStream(Graph graph, TransitService transitService) {
        StopLocation stopLocation = this.transferStop;
        if (stopLocation instanceof RegularStop) {
            RegularStop stop = (RegularStop)stopLocation;
            TransitStopVertex flexVertex = graph.getStopVertexForStopId(stop.getId());
            return Stream.of(this.getFlexAccessEgress(new ArrayList<Edge>(), flexVertex, (RegularStop)this.transferStop)).filter(Objects::nonNull);
        }
        double maxDistanceMeters = (double)this.flexConfig.maxTransferDuration().getSeconds() * this.accessEgress.state.getRequest().preferences().walk().speed();
        return this.getTransfersFromTransferStop(transitService).stream().filter(pathTransfer -> pathTransfer.getDistanceMeters() <= maxDistanceMeters).filter(transfer -> this.getFinalStop((PathTransfer)transfer) != null).map(transfer -> {
            List<Edge> edges = this.getTransferEdges((PathTransfer)transfer);
            return this.getFlexAccessEgress(edges, this.getFlexVertex(edges.get(0)), this.getFinalStop((PathTransfer)transfer));
        }).filter(Objects::nonNull);
    }

    public String toString() {
        return ToStringBuilder.of(FlexAccessEgressTemplate.class).addObj("accessEgress", this.accessEgress).addObj("trip", this.trip).addNum("fromStopIndex", this.fromStopIndex).addNum("toStopIndex", this.toStopIndex).addObj("transferStop", this.transferStop).addServiceTime("secondsFromStartOfTime", this.secondsFromStartOfTime).addDate("serviceDate", this.serviceDate).addObj("calculator", this.calculator).addObj("flexConfig", this.flexConfig).toString();
    }

    protected abstract List<Edge> getTransferEdges(PathTransfer var1);

    protected abstract RegularStop getFinalStop(PathTransfer var1);

    protected abstract Collection<PathTransfer> getTransfersFromTransferStop(TransitService var1);

    protected abstract Vertex getFlexVertex(Edge var1);

    protected abstract int[] getFlexTimes(FlexTripEdge var1, State var2);

    protected abstract FlexTripEdge getFlexEdge(Vertex var1, StopLocation var2);

    protected FlexAccessEgress getFlexAccessEgress(List<Edge> transferEdges, Vertex flexVertex, RegularStop stop) {
        FlexTripEdge flexEdge = this.getFlexEdge(flexVertex, this.transferStop);
        State state = flexEdge.traverse(this.accessEgress.state);
        if (state == null) {
            return null;
        }
        for (Edge e : transferEdges) {
            state = e.traverse(state);
            if (state != null) continue;
            return null;
        }
        int[] times = this.getFlexTimes(flexEdge, state);
        return new FlexAccessEgress(stop, times[0], times[1], times[2], this.fromStopIndex, this.toStopIndex, this.secondsFromStartOfTime, this.trip, state, transferEdges.isEmpty());
    }
}

