/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.flex;

import java.time.Duration;
import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.locationtech.jts.geom.LineString;
import org.opentripplanner.ext.flex.edgetype.FlexTripEdge;
import org.opentripplanner.framework.i18n.I18NString;
import org.opentripplanner.framework.lang.DoubleUtils;
import org.opentripplanner.framework.tostring.ToStringBuilder;
import org.opentripplanner.model.BookingInfo;
import org.opentripplanner.model.PickDrop;
import org.opentripplanner.model.plan.Leg;
import org.opentripplanner.model.plan.Place;
import org.opentripplanner.model.plan.StopArrival;
import org.opentripplanner.model.plan.TransitLeg;
import org.opentripplanner.routing.alertpatch.TransitAlert;
import org.opentripplanner.transit.model.basic.Accessibility;
import org.opentripplanner.transit.model.basic.TransitMode;
import org.opentripplanner.transit.model.framework.AbstractTransitEntity;
import org.opentripplanner.transit.model.network.Route;
import org.opentripplanner.transit.model.organization.Agency;
import org.opentripplanner.transit.model.organization.Operator;
import org.opentripplanner.transit.model.timetable.Trip;

public class FlexibleTransitLeg
implements TransitLeg {
    private final FlexTripEdge edge;
    private final ZonedDateTime startTime;
    private final ZonedDateTime endTime;
    private final Set<TransitAlert> transitAlerts = new HashSet<TransitAlert>();
    private final int generalizedCost;

    public FlexibleTransitLeg(FlexTripEdge flexTripEdge, ZonedDateTime startTime, ZonedDateTime endTime, int generalizedCost) {
        this.edge = flexTripEdge;
        this.startTime = startTime;
        this.endTime = endTime;
        this.generalizedCost = generalizedCost;
    }

    @Override
    public Agency getAgency() {
        return this.getTrip().getRoute().getAgency();
    }

    @Override
    public Operator getOperator() {
        return this.getTrip().getOperator();
    }

    @Override
    public Route getRoute() {
        return this.getTrip().getRoute();
    }

    @Override
    public Trip getTrip() {
        return this.edge.getFlexTrip().getTrip();
    }

    @Override
    public Accessibility getTripWheelchairAccessibility() {
        return this.edge.getFlexTrip().getTrip().getWheelchairBoarding();
    }

    @Override
    @Nonnull
    public TransitMode getMode() {
        return this.getTrip().getMode();
    }

    @Override
    public ZonedDateTime getStartTime() {
        return this.startTime;
    }

    @Override
    public ZonedDateTime getEndTime() {
        return this.endTime;
    }

    @Override
    public boolean isFlexibleTrip() {
        return true;
    }

    @Override
    public double getDistanceMeters() {
        return DoubleUtils.roundTo2Decimals(this.edge.getDistanceMeters());
    }

    @Override
    public Integer getRouteType() {
        return this.getTrip().getRoute().getGtfsType();
    }

    @Override
    public I18NString getHeadsign() {
        return this.getTrip().getHeadsign();
    }

    @Override
    public LocalDate getServiceDate() {
        return this.edge.flexTemplate.serviceDate;
    }

    @Override
    public Place getFrom() {
        return Place.forFlexStop(this.edge.s1, this.edge.getFromVertex());
    }

    @Override
    public Place getTo() {
        return Place.forFlexStop(this.edge.s2, this.edge.getToVertex());
    }

    @Override
    public List<StopArrival> getIntermediateStops() {
        return List.of();
    }

    @Override
    public LineString getLegGeometry() {
        return this.edge.getGeometry();
    }

    @Override
    public Set<TransitAlert> getTransitAlerts() {
        return this.transitAlerts;
    }

    @Override
    public PickDrop getBoardRule() {
        return this.edge.getFlexTrip().getBoardRule(this.getBoardStopPosInPattern());
    }

    @Override
    public PickDrop getAlightRule() {
        return this.edge.getFlexTrip().getAlightRule(this.getAlightStopPosInPattern());
    }

    @Override
    public BookingInfo getDropOffBookingInfo() {
        return this.edge.getFlexTrip().getDropOffBookingInfo(this.getBoardStopPosInPattern());
    }

    @Override
    public BookingInfo getPickupBookingInfo() {
        return this.edge.getFlexTrip().getPickupBookingInfo(this.getAlightStopPosInPattern());
    }

    @Override
    public Integer getBoardStopPosInPattern() {
        return this.edge.flexTemplate.fromStopIndex;
    }

    @Override
    public Integer getAlightStopPosInPattern() {
        return this.edge.flexTemplate.toStopIndex;
    }

    @Override
    public int getGeneralizedCost() {
        return this.generalizedCost;
    }

    @Override
    public void addAlert(TransitAlert alert) {
        this.transitAlerts.add(alert);
    }

    @Override
    public Leg withTimeShift(Duration duration) {
        FlexibleTransitLeg copy = new FlexibleTransitLeg(this.edge, this.startTime.plus(duration), this.endTime.plus(duration), this.generalizedCost);
        for (TransitAlert alert : this.transitAlerts) {
            copy.addAlert(alert);
        }
        return copy;
    }

    public String toString() {
        return ToStringBuilder.of(FlexibleTransitLeg.class).addObj("from", this.getFrom()).addObj("to", this.getTo()).addTime("startTime", this.startTime).addTime("endTime", this.endTime).addNum("distance", (Number)this.getDistanceMeters(), "m").addNum("cost", this.generalizedCost).addObjOp("agencyId", this.getAgency(), AbstractTransitEntity::getId).addObjOp("routeId", this.getRoute(), AbstractTransitEntity::getId).addObjOp("tripId", this.getTrip(), AbstractTransitEntity::getId).addObj("serviceDate", this.getServiceDate()).addObj("legGeometry", this.getLegGeometry()).addCol("transitAlerts", this.transitAlerts).addNum("boardingStopIndex", this.getBoardStopPosInPattern()).addNum("alightStopIndex", this.getAlightStopPosInPattern()).addEnum("boardRule", this.getBoardRule()).addEnum("alightRule", this.getAlightRule()).addObj("pickupBookingInfo", this.getPickupBookingInfo()).addObj("dropOffBookingInfo", this.getDropOffBookingInfo()).toString();
    }
}

