/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.flex;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.opentripplanner.ext.flex.FlexAccessEgress;
import org.opentripplanner.ext.flex.FlexIndex;
import org.opentripplanner.ext.flex.FlexServiceDate;
import org.opentripplanner.ext.flex.flexpathcalculator.DirectFlexPathCalculator;
import org.opentripplanner.ext.flex.flexpathcalculator.FlexPathCalculator;
import org.opentripplanner.ext.flex.flexpathcalculator.StreetFlexPathCalculator;
import org.opentripplanner.ext.flex.template.FlexAccessTemplate;
import org.opentripplanner.ext.flex.template.FlexEgressTemplate;
import org.opentripplanner.ext.flex.trip.FlexTrip;
import org.opentripplanner.framework.time.ServiceDateUtils;
import org.opentripplanner.model.plan.Itinerary;
import org.opentripplanner.routing.algorithm.mapping.GraphPathToItineraryMapper;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.routing.graphfinder.NearbyStop;
import org.opentripplanner.standalone.config.sandbox.FlexConfig;
import org.opentripplanner.transit.model.site.StopLocation;
import org.opentripplanner.transit.service.TransitService;

public class FlexRouter {
    private final Graph graph;
    private final TransitService transitService;
    private final FlexConfig config;
    private final Collection<NearbyStop> streetAccesses;
    private final Collection<NearbyStop> streetEgresses;
    private final FlexIndex flexIndex;
    private final FlexPathCalculator accessFlexPathCalculator;
    private final FlexPathCalculator egressFlexPathCalculator;
    private final GraphPathToItineraryMapper graphPathToItineraryMapper;
    private final ZonedDateTime startOfTime;
    private final int departureTime;
    private final boolean arriveBy;
    private final FlexServiceDate[] dates;
    private List<FlexAccessTemplate> flexAccessTemplates = null;
    private List<FlexEgressTemplate> flexEgressTemplates = null;

    public FlexRouter(Graph graph, TransitService transitService, FlexConfig config, Instant searchInstant, boolean arriveBy, int additionalPastSearchDays, int additionalFutureSearchDays, Collection<NearbyStop> streetAccesses, Collection<NearbyStop> egressTransfers) {
        this.graph = graph;
        this.transitService = transitService;
        this.config = config;
        this.streetAccesses = streetAccesses;
        this.streetEgresses = egressTransfers;
        this.flexIndex = transitService.getFlexIndex();
        this.graphPathToItineraryMapper = new GraphPathToItineraryMapper(transitService.getTimeZone(), graph.streetNotesService, graph.ellipsoidToGeoidDifference);
        if (graph.hasStreets) {
            this.accessFlexPathCalculator = new StreetFlexPathCalculator(false, config.maxFlexTripDuration());
            this.egressFlexPathCalculator = new StreetFlexPathCalculator(true, config.maxFlexTripDuration());
        } else {
            this.accessFlexPathCalculator = new DirectFlexPathCalculator();
            this.egressFlexPathCalculator = new DirectFlexPathCalculator();
        }
        ZoneId tz = transitService.getTimeZone();
        LocalDate searchDate = LocalDate.ofInstant(searchInstant, tz);
        this.startOfTime = ServiceDateUtils.asStartOfService(searchDate, tz);
        this.departureTime = ServiceDateUtils.secondsSinceStartOfTime(this.startOfTime, searchInstant);
        this.arriveBy = arriveBy;
        int totalDays = additionalPastSearchDays + 1 + additionalFutureSearchDays;
        this.dates = new FlexServiceDate[totalDays];
        for (int d = -additionalPastSearchDays; d <= additionalFutureSearchDays; ++d) {
            LocalDate date = searchDate.plusDays(d);
            int index = d + additionalPastSearchDays;
            this.dates[index] = new FlexServiceDate(date, ServiceDateUtils.secondsSinceStartOfTime(this.startOfTime, date), transitService.getServiceCodesRunningForDate(date));
        }
    }

    public Collection<Itinerary> createFlexOnlyItineraries() {
        this.calculateFlexAccessTemplates();
        this.calculateFlexEgressTemplates();
        HashMultimap streetEgressByStop = HashMultimap.create();
        this.streetEgresses.forEach(arg_0 -> FlexRouter.lambda$createFlexOnlyItineraries$0((Multimap)streetEgressByStop, arg_0));
        ArrayList<Itinerary> itineraries = new ArrayList<Itinerary>();
        for (FlexAccessTemplate template : this.flexAccessTemplates) {
            StopLocation transferStop = template.getTransferStop();
            if (!this.flexEgressTemplates.stream().anyMatch(t -> t.getAccessEgressStop().equals(transferStop))) continue;
            for (NearbyStop egress : streetEgressByStop.get((Object)transferStop)) {
                Itinerary itinerary = template.createDirectGraphPath(egress, this.arriveBy, this.departureTime, this.startOfTime, this.graphPathToItineraryMapper);
                if (itinerary == null) continue;
                itineraries.add(itinerary);
            }
        }
        return itineraries;
    }

    public Collection<FlexAccessEgress> createFlexAccesses() {
        this.calculateFlexAccessTemplates();
        return this.flexAccessTemplates.stream().flatMap(template -> template.createFlexAccessEgressStream(this.graph, this.transitService)).collect(Collectors.toList());
    }

    public Collection<FlexAccessEgress> createFlexEgresses() {
        this.calculateFlexEgressTemplates();
        return this.flexEgressTemplates.stream().flatMap(template -> template.createFlexAccessEgressStream(this.graph, this.transitService)).collect(Collectors.toList());
    }

    private void calculateFlexAccessTemplates() {
        if (this.flexAccessTemplates != null) {
            return;
        }
        this.flexAccessTemplates = this.getClosestFlexTrips(this.streetAccesses, true).flatMap(it -> Arrays.stream(this.dates).filter(date -> date.isFlexTripRunning(it.flexTrip(), this.transitService)).flatMap(date -> it.flexTrip().getFlexAccessTemplates(it.accessEgress(), (FlexServiceDate)date, this.accessFlexPathCalculator, this.config))).collect(Collectors.toList());
    }

    private void calculateFlexEgressTemplates() {
        if (this.flexEgressTemplates != null) {
            return;
        }
        this.flexEgressTemplates = this.getClosestFlexTrips(this.streetEgresses, false).flatMap(it -> Arrays.stream(this.dates).filter(date -> date.isFlexTripRunning(it.flexTrip(), this.transitService)).flatMap(date -> it.flexTrip().getFlexEgressTemplates(it.accessEgress(), (FlexServiceDate)date, this.egressFlexPathCalculator, this.config))).collect(Collectors.toList());
    }

    private Stream<AccessEgressAndNearbyStop> getClosestFlexTrips(Collection<NearbyStop> nearbyStops, boolean pickup) {
        Stream<Map<FlexTrip, List<AccessEgressAndNearbyStop>>> flexTripsReachableFromNearbyStops = nearbyStops.stream().flatMap(accessEgress -> this.flexIndex.getFlexTripsByStop(accessEgress.stop).stream().filter(flexTrip -> pickup ? flexTrip.isBoardingPossible((NearbyStop)accessEgress) : flexTrip.isAlightingPossible((NearbyStop)accessEgress)).map(flexTrip -> new AccessEgressAndNearbyStop((NearbyStop)accessEgress, (FlexTrip<?, ?>)flexTrip)));
        Collection<List<AccessEgressAndNearbyStop>> groupedReachableFlexTrips = flexTripsReachableFromNearbyStops.collect(Collectors.groupingBy(AccessEgressAndNearbyStop::flexTrip)).values();
        return groupedReachableFlexTrips.stream().map(t2s -> t2s.stream().min(Comparator.comparingLong(t2 -> t2.accessEgress().state.getElapsedTimeSeconds()))).flatMap(Optional::stream);
    }

    private static /* synthetic */ void lambda$createFlexOnlyItineraries$0(Multimap streetEgressByStop, NearbyStop it) {
        streetEgressByStop.put((Object)it.stop, (Object)it);
    }

    private record AccessEgressAndNearbyStop(NearbyStop accessEgress, FlexTrip<?, ?> flexTrip) {
    }
}

