/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.fares.model;

import java.util.Objects;
import javax.annotation.Nonnull;
import org.opentripplanner.ext.fares.model.FareAttributeBuilder;
import org.opentripplanner.transit.model.framework.AbstractTransitEntity;
import org.opentripplanner.transit.model.framework.FeedScopedId;

public final class FareAttribute
extends AbstractTransitEntity<FareAttribute, FareAttributeBuilder> {
    private FeedScopedId agency;
    private final float price;
    private final String currencyType;
    private final int paymentMethod;
    private final Integer transfers;
    private final Integer transferDuration;
    private final float youthPrice;
    private final float seniorPrice;
    private final Integer journeyDuration;

    FareAttribute(FareAttributeBuilder builder) {
        super(builder.getId());
        this.price = builder.price();
        this.currencyType = builder.currencyType();
        this.paymentMethod = builder.paymentMethod();
        this.transfers = builder.transfers();
        this.transferDuration = builder.transferDuration();
        this.youthPrice = builder.youthPrice();
        this.seniorPrice = builder.seniorPrice();
        this.journeyDuration = builder.journeyDuration();
        this.agency = builder.agency();
    }

    public static FareAttributeBuilder of(FeedScopedId id) {
        return new FareAttributeBuilder(id);
    }

    public boolean isAgencySet() {
        return this.agency != null;
    }

    public FeedScopedId getAgency() {
        return this.agency;
    }

    public void setAgency(FeedScopedId agency) {
        this.agency = agency;
    }

    public float getPrice() {
        return this.price;
    }

    public String getCurrencyType() {
        return this.currencyType;
    }

    public int getPaymentMethod() {
        return this.paymentMethod;
    }

    public boolean isTransfersSet() {
        return this.transfers != null;
    }

    public Integer getTransfers() {
        return this.transfers;
    }

    public boolean isTransferDurationSet() {
        return this.transferDuration != null;
    }

    public Integer getTransferDuration() {
        return this.transferDuration;
    }

    public boolean isJourneyDurationSet() {
        return this.journeyDuration != null;
    }

    public Integer getJourneyDuration() {
        return this.journeyDuration;
    }

    public float getYouthPrice() {
        return this.youthPrice;
    }

    public float getSeniorPrice() {
        return this.seniorPrice;
    }

    @Override
    public boolean sameAs(@Nonnull FareAttribute other) {
        return this.getId().equals(other.getId()) && this.price == other.getPrice() && Objects.equals(this.currencyType, other.getCurrencyType()) && this.paymentMethod == other.getPaymentMethod() && Objects.equals(this.transfers, other.getTransfers()) && Objects.equals(this.transferDuration, other.getTransferDuration()) && this.youthPrice == other.getYouthPrice() && this.seniorPrice == other.getSeniorPrice() && Objects.equals(this.journeyDuration, other.getJourneyDuration());
    }

    @Nonnull
    public FareAttributeBuilder copy() {
        return new FareAttributeBuilder(this);
    }
}

