/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.fares.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Currency;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.opentripplanner.ext.fares.impl.DefaultFareService;
import org.opentripplanner.ext.fares.model.FareRuleSet;
import org.opentripplanner.model.plan.Leg;
import org.opentripplanner.model.plan.TransitLeg;
import org.opentripplanner.routing.core.FareType;
import org.opentripplanner.routing.core.ItineraryFares;
import org.opentripplanner.transit.model.basic.TransitMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SFBayFareServiceImpl
extends DefaultFareService {
    private static final Logger LOG = LoggerFactory.getLogger(SFBayFareServiceImpl.class);
    public static final int SFMTA_TRANSFER_DURATION = 5400;
    public static final int BART_TRANSFER_DURATION = 3600;
    public static final float SFMTA_BASE_FARE = 2.0f;
    public static final float CABLE_CAR_FARE = 5.0f;
    public static final float AIRBART_FARE = 3.0f;
    public static final float SFMTA_BART_TRANSFER_FARE = 1.75f;
    public static final Set<String> SFMTA_BART_TRANSFER_STOPS = new HashSet<String>(Arrays.asList("EMBR", "MONT", "POWL", "CIVC", "16TH", "24TH", "GLEN", "BALB", "DALY"));
    public static final String SFMTA_BART_FREE_TRANSFER_STOP = "DALY";

    public SFBayFareServiceImpl(Collection<FareRuleSet> regularFareRules) {
        this.addFareRules(FareType.regular, regularFareRules);
    }

    @Override
    protected float getLowestCost(FareType fareType, List<Leg> rides, Collection<FareRuleSet> fareRules) {
        ArrayList<Leg> bartBlock = null;
        Long sfmtaTransferIssued = null;
        Long alightedBart = null;
        String alightedBartStop = null;
        float cost = 0.0f;
        String agencyId = null;
        for (Leg ride : rides) {
            agencyId = ride.getRoute().getId().getFeedId();
            if (agencyId.equals("BART")) {
                if (bartBlock == null) {
                    bartBlock = new ArrayList<Leg>();
                }
                bartBlock.add(ride);
                alightedBart = ride.getEndTime().toEpochSecond();
                alightedBartStop = ride.getTo().stop.getId().getId();
                continue;
            }
            if (bartBlock != null) {
                cost += this.calculateCost(fareType, bartBlock, fareRules);
                bartBlock = null;
            }
            if (agencyId.equals("SFMTA")) {
                TransitMode mode;
                if (ride instanceof TransitLeg) {
                    TransitLeg transitLeg = (TransitLeg)ride;
                    v0 = transitLeg.getMode();
                } else {
                    v0 = mode = null;
                }
                if (mode == TransitMode.CABLE_CAR) {
                    cost += 5.0f;
                    continue;
                }
                if (sfmtaTransferIssued != null && sfmtaTransferIssued + 5400L >= ride.getEndTime().toEpochSecond()) continue;
                sfmtaTransferIssued = ride.getStartTime().toEpochSecond();
                if (alightedBart != null && alightedBart + 3600L > ride.getEndTime().toEpochSecond() && SFMTA_BART_TRANSFER_STOPS.contains(alightedBartStop)) {
                    if (alightedBartStop.equals(SFMTA_BART_FREE_TRANSFER_STOP)) continue;
                    cost += 1.75f;
                    continue;
                }
                cost += 2.0f;
                continue;
            }
            if (!agencyId.equals("AirBART")) continue;
            cost += 3.0f;
        }
        if (bartBlock != null) {
            cost += this.calculateCost(fareType, bartBlock, fareRules);
        }
        return cost;
    }

    @Override
    protected boolean populateFare(ItineraryFares fare, Currency currency, FareType fareType, List<Leg> rides, Collection<FareRuleSet> fareRules) {
        float lowestCost = this.getLowestCost(fareType, rides, fareRules);
        if (lowestCost != Float.POSITIVE_INFINITY) {
            fare.addFare(fareType, SFBayFareServiceImpl.getMoney(currency, lowestCost));
            return true;
        }
        return false;
    }
}

