/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.fares.impl;

import com.fasterxml.jackson.databind.JsonNode;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import org.opentripplanner.ext.fares.impl.DefaultFareServiceFactory;
import org.opentripplanner.ext.fares.impl.HighestFareInFreeTransferWindowFareService;
import org.opentripplanner.ext.fares.model.FareRuleSet;
import org.opentripplanner.ext.fares.model.FareRulesData;
import org.opentripplanner.model.OtpTransitService;
import org.opentripplanner.routing.fares.FareService;
import org.opentripplanner.standalone.config.framework.json.NodeAdapter;
import org.opentripplanner.standalone.config.framework.json.OtpVersion;
import org.opentripplanner.transit.model.framework.FeedScopedId;

public class HighestFareInFreeTransferWindowFareServiceFactory
extends DefaultFareServiceFactory {
    protected Map<FeedScopedId, FareRuleSet> regularFareRules = new HashMap<FeedScopedId, FareRuleSet>();
    private Duration freeTransferWindow = Duration.ofMinutes(150L);
    private boolean analyzeInterlinedTransfers = false;

    @Override
    public FareService makeFareService() {
        return new HighestFareInFreeTransferWindowFareService(this.regularFareRules.values(), this.freeTransferWindow, this.analyzeInterlinedTransfers);
    }

    @Override
    public void processGtfs(FareRulesData fareRulesData, OtpTransitService transitService) {
        this.fillFareRules(fareRulesData.fareAttributes(), fareRulesData.fareRules(), this.regularFareRules);
    }

    @Override
    public void configure(JsonNode config) {
        NodeAdapter adapter = new NodeAdapter(config, null);
        this.freeTransferWindow = adapter.of("freeTransferWindow").since(OtpVersion.NA).summary("TODO").asDuration(this.freeTransferWindow);
        this.analyzeInterlinedTransfers = adapter.of("analyzeInterlinedTransfers").since(OtpVersion.NA).summary("TODO").asBoolean(this.analyzeInterlinedTransfers);
    }
}

