/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.fares.impl;

import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.opentripplanner.ext.fares.impl.DefaultFareService;
import org.opentripplanner.ext.fares.impl.FareAndId;
import org.opentripplanner.ext.fares.model.FareAttribute;
import org.opentripplanner.ext.fares.model.FareRuleSet;
import org.opentripplanner.ext.fares.model.RouteOriginDestination;
import org.opentripplanner.model.plan.Leg;
import org.opentripplanner.model.plan.ScheduledTransitLeg;
import org.opentripplanner.routing.core.FareType;
import org.opentripplanner.transit.model.framework.AbstractTransitEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HSLFareServiceImpl
extends DefaultFareService {
    private static final Logger LOG = LoggerFactory.getLogger(HSLFareServiceImpl.class);

    @Override
    protected boolean shouldCombineInterlinedLegs(ScheduledTransitLeg previousLeg, ScheduledTransitLeg currentLeg) {
        return true;
    }

    @Override
    protected FareAndId getBestFareAndId(FareType fareType, List<Leg> legs, Collection<FareRuleSet> fareRules) {
        ZonedDateTime startTime;
        HashSet<String> zones = new HashSet<String>();
        ZonedDateTime lastRideStartTime = startTime = legs.get(0).getStartTime();
        float specialRouteFare = Float.POSITIVE_INFINITY;
        AbstractTransitEntity specialFareAttribute = null;
        String agency = null;
        boolean singleAgency = true;
        for (Leg leg : legs) {
            lastRideStartTime = leg.getStartTime();
            if (agency == null) {
                agency = leg.getAgency().getId().getId().toString();
            } else if (agency != leg.getAgency().getId().getId().toString()) {
                singleAgency = false;
            }
            float bestSpecialFare = Float.POSITIVE_INFINITY;
            Set<String> ruleZones = null;
            for (FareRuleSet ruleSet : fareRules) {
                float newFare;
                FareAttribute attribute;
                if (ruleSet.hasAgencyDefined() && leg.getAgency().getId().getId() != ruleSet.getAgency().getId()) continue;
                RouteOriginDestination routeOriginDestination = new RouteOriginDestination(leg.getRoute().getId().toString(), leg.getFrom().stop.getFirstZoneAsString(), leg.getTo().stop.getFirstZoneAsString());
                boolean isSpecialRoute = false;
                if (!ruleSet.getRouteOriginDestinations().isEmpty() && ruleSet.getRouteOriginDestinations().toString().indexOf(routeOriginDestination.toString()) != -1) {
                    isSpecialRoute = true;
                }
                if (!isSpecialRoute && (!ruleSet.getRoutes().contains(leg.getRoute().getId()) || !ruleSet.getContains().contains(leg.getFrom().stop.getFirstZoneAsString()) || !ruleSet.getContains().contains(leg.getTo().stop.getFirstZoneAsString())) || (attribute = ruleSet.getFareAttribute()).isTransferDurationSet() && Duration.between(lastRideStartTime, startTime).getSeconds() >= (long)attribute.getTransferDuration().intValue() || !((newFare = this.getFarePrice(attribute, fareType)) < bestSpecialFare)) continue;
                bestSpecialFare = newFare;
                ruleZones = ruleSet.getContains();
                if (!isSpecialRoute) continue;
                specialRouteFare = bestSpecialFare;
                specialFareAttribute = attribute;
            }
            if (ruleZones != null) {
                HashSet<String> zoneIntersection = new HashSet<String>(leg.getFareZones().stream().map(z -> z.getId().getId()).toList());
                zoneIntersection.retainAll(ruleZones);
                zones.addAll(zoneIntersection);
                continue;
            }
            zones.addAll(leg.getFareZones().stream().map(z -> z.getId().getId()).toList());
        }
        AbstractTransitEntity bestAttribute = null;
        float bestFare = Float.POSITIVE_INFINITY;
        long tripTime = Duration.between(startTime, lastRideStartTime).getSeconds();
        if (zones.size() > 0) {
            for (FareRuleSet ruleSet : fareRules) {
                float newFare;
                if (ruleSet.hasAgencyDefined() && (!singleAgency || agency != ruleSet.getAgency().getId()) || !ruleSet.getContains().containsAll(zones)) continue;
                FareAttribute attribute = ruleSet.getFareAttribute();
                if (attribute.isTransferDurationSet()) {
                    if (tripTime > (long)attribute.getTransferDuration().intValue()) {
                        LOG.debug("transfer time exceeded; {} > {} in fare {}", new Object[]{tripTime, attribute.getTransferDuration(), attribute.getId()});
                        continue;
                    }
                    LOG.debug("transfer time OK; {} < {} in fare {}", new Object[]{tripTime, attribute.getTransferDuration(), attribute.getId()});
                }
                if (!((newFare = this.getFarePrice(attribute, fareType)) < bestFare)) continue;
                bestAttribute = attribute;
                bestFare = newFare;
            }
        } else if (specialRouteFare != Float.POSITIVE_INFINITY && specialFareAttribute != null) {
            bestFare = specialRouteFare;
            bestAttribute = specialFareAttribute;
        }
        LOG.debug("HSL {} best for {}", bestAttribute, legs);
        return new FareAndId(bestFare, bestAttribute == null ? null : bestAttribute.getId());
    }
}

