/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.fares.impl;

import java.util.Collection;
import java.util.Map;
import org.opentripplanner.ext.fares.impl.DefaultFareServiceFactory;
import org.opentripplanner.ext.fares.impl.HSLFareServiceImpl;
import org.opentripplanner.ext.fares.model.FareAttribute;
import org.opentripplanner.ext.fares.model.FareRule;
import org.opentripplanner.ext.fares.model.FareRuleSet;
import org.opentripplanner.routing.core.FareType;
import org.opentripplanner.routing.fares.FareService;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.network.Route;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HSLFareServiceFactory
extends DefaultFareServiceFactory {
    private static final Logger LOG = LoggerFactory.getLogger(HSLFareServiceImpl.class);

    @Override
    protected void fillFareRules(Collection<FareAttribute> fareAttributes, Collection<FareRule> fareRules, Map<FeedScopedId, FareRuleSet> fareRuleSet) {
        for (FareAttribute fare : fareAttributes) {
            FeedScopedId id = fare.getId();
            FareRuleSet fareRule = fareRuleSet.get(id);
            if (fareRule != null) continue;
            fareRule = new FareRuleSet(fare);
            fareRuleSet.put(id, fareRule);
        }
        for (FareRule rule : fareRules) {
            FareAttribute fare = rule.getFare();
            FeedScopedId id = fare.getId();
            FareRuleSet fareRule = fareRuleSet.get(id);
            if (fare.getAgency() != null) {
                fareRule.setAgency(fare.getAgency());
            }
            if (fareRule == null) {
                LOG.error("Inexistant fare ID in fare rule: " + id);
                continue;
            }
            String contains = rule.getContainsId();
            if (contains != null) {
                fareRule.addContains(contains);
            }
            String origin = rule.getOriginId();
            String destination = rule.getDestinationId();
            Route route = rule.getRoute();
            if (route != null) {
                FeedScopedId routeId = route.getId();
                if (origin != null && destination != null) {
                    fareRule.addRouteOriginDestination(routeId.toString(), origin, destination);
                    continue;
                }
                fareRule.addRoute(routeId);
                continue;
            }
            if (origin == null && destination == null) continue;
            fareRule.addOriginDestination(origin, destination);
        }
    }

    @Override
    public FareService makeFareService() {
        HSLFareServiceImpl fareService = new HSLFareServiceImpl();
        fareService.addFareRules(FareType.regular, this.regularFareRules.values());
        if (LOG.isDebugEnabled()) {
            for (FareRuleSet ruleSet : this.regularFareRules.values()) {
                LOG.debug("farerule {}", (Object)ruleSet);
                LOG.debug("ruleattr {}", (Object)ruleSet.getFareAttribute());
                LOG.debug("hasAgency {}", (Object)ruleSet.hasAgencyDefined());
                LOG.debug("agency {}", (Object)ruleSet.getAgency());
            }
        }
        return fareService;
    }
}

