/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.fares.impl;

import java.time.ZonedDateTime;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.locationtech.jts.geom.LineString;
import org.opentripplanner.framework.collection.ListUtils;
import org.opentripplanner.model.plan.Place;
import org.opentripplanner.model.plan.StopArrival;
import org.opentripplanner.model.plan.TransitLeg;
import org.opentripplanner.transit.model.basic.TransitMode;
import org.opentripplanner.transit.model.network.Route;
import org.opentripplanner.transit.model.organization.Agency;
import org.opentripplanner.transit.model.site.FareZone;
import org.opentripplanner.transit.model.timetable.Trip;

class CombinedInterlinedTransitLeg
implements TransitLeg {
    private final TransitLeg first;
    private final TransitLeg second;

    public CombinedInterlinedTransitLeg(TransitLeg first, TransitLeg second) {
        this.first = first;
        this.second = second;
    }

    @Override
    public Agency getAgency() {
        return this.first.getAgency();
    }

    @Override
    @Nonnull
    public TransitMode getMode() {
        return this.first.getMode();
    }

    @Override
    @Nonnull
    public Route getRoute() {
        return this.first.getRoute();
    }

    @Override
    @Nonnull
    public Trip getTrip() {
        return this.first.getTrip();
    }

    @Override
    public ZonedDateTime getStartTime() {
        return this.first.getStartTime();
    }

    @Override
    public ZonedDateTime getEndTime() {
        return this.second.getStartTime();
    }

    @Override
    public double getDistanceMeters() {
        return this.first.getDistanceMeters() + this.second.getDistanceMeters();
    }

    @Override
    public Place getFrom() {
        return this.first.getFrom();
    }

    @Override
    public Place getTo() {
        return this.second.getTo();
    }

    @Override
    public List<StopArrival> getIntermediateStops() {
        return ListUtils.combine(this.first.getIntermediateStops(), this.second.getIntermediateStops());
    }

    @Override
    public LineString getLegGeometry() {
        return null;
    }

    @Override
    public int getGeneralizedCost() {
        if (this.first.getGeneralizedCost() == -1) {
            return this.second.getGeneralizedCost();
        }
        if (this.second.getGeneralizedCost() == -1) {
            return this.first.getGeneralizedCost();
        }
        return this.first.getGeneralizedCost() + this.second.getGeneralizedCost();
    }

    @Override
    public Set<FareZone> getFareZones() {
        Set<FareZone> fareZones = this.first.getFareZones();
        fareZones.addAll(this.second.getFareZones());
        return fareZones;
    }
}

