/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.dataoverlay;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class EdgeGenQuality<E extends Number> {
    private final Map<Integer, List<E>> gridDataVariableValues = new HashMap<Integer, List<E>>();

    EdgeGenQuality() {
    }

    void addPropertyValueSample(int time, E propertyValue) {
        List<E> existing = this.gridDataVariableValues.get(time);
        if (existing == null) {
            this.gridDataVariableValues.put(time, List.of(propertyValue));
        } else {
            ArrayList<E> updated = new ArrayList<E>(existing.size() + 1);
            updated.addAll(existing);
            updated.add(existing.size(), propertyValue);
            this.gridDataVariableValues.put(time, updated);
        }
    }

    float getPropertyValue(int time) {
        return this.getAverage(this.getPropertyValuesInTime(time));
    }

    float[] getPropertyValueAverage(int times) {
        float[] result = new float[times];
        for (int time = 0; time < times; ++time) {
            result[time] = this.getPropertyValue(time);
        }
        return result;
    }

    private float getAverage(List<E> values) {
        if (values == null) {
            return 0.0f;
        }
        return this.calculateAverage(values);
    }

    private float calculateAverage(List<E> values) {
        int len = values.size();
        if (values.get(0) instanceof Integer) {
            Integer total = 0;
            for (Number value : values) {
                total = total + (Integer)value;
            }
            return (float)total.intValue() / (float)len;
        }
        if (values.get(0) instanceof Float) {
            float sum = 0.0f;
            for (Number value : values) {
                sum += ((Float)value).floatValue();
            }
            return sum / (float)len;
        }
        if (values.get(0) instanceof Double) {
            double sum = 0.0;
            for (Number value : values) {
                sum += ((Double)value).doubleValue();
            }
            return (float)sum / (float)len;
        }
        if (values.get(0) instanceof Long) {
            Long total = 0L;
            for (Number value : values) {
                total = total + (Long)value;
            }
            return (float)total.longValue() / (float)len;
        }
        throw new UnsupportedOperationException("Unrecognizable format of " + values.get(0));
    }

    private List<E> getPropertyValuesInTime(int time) {
        return this.gridDataVariableValues.get(time);
    }
}

