/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.datastore.file;

import java.io.InputStream;
import java.net.URI;
import java.util.zip.ZipEntry;
import org.opentripplanner.datastore.api.DataSource;
import org.opentripplanner.datastore.api.FileType;
import org.opentripplanner.datastore.file.ZipFileEntryParent;

public class ZipFileEntryDataSource
implements DataSource {
    private final ZipFileEntryParent parent;
    private final ZipEntry entry;

    ZipFileEntryDataSource(ZipFileEntryParent parent, ZipEntry entry) {
        this.parent = parent;
        this.entry = entry;
    }

    @Override
    public String name() {
        return this.entry.getName();
    }

    @Override
    public String path() {
        return this.name() + " (" + this.parent.path() + ")";
    }

    @Override
    public URI uri() {
        return URI.create(this.path());
    }

    @Override
    public FileType type() {
        return this.parent.type();
    }

    @Override
    public long size() {
        return this.entry.getSize();
    }

    @Override
    public long lastModified() {
        return this.entry.getLastModifiedTime().toMillis();
    }

    @Override
    public boolean isWritable() {
        return false;
    }

    @Override
    public InputStream asInputStream() {
        return this.parent.entryStream(this.entry);
    }

    public String toString() {
        return this.type() + " " + this.path();
    }
}

