/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.datastore.file;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.opentripplanner.datastore.api.CompositeDataSource;
import org.opentripplanner.datastore.api.DataSource;
import org.opentripplanner.datastore.api.FileType;
import org.opentripplanner.datastore.file.AbstractFileDataSource;
import org.opentripplanner.datastore.file.ZipFileEntryDataSource;
import org.opentripplanner.datastore.file.ZipFileEntryParent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipFileDataSource
extends AbstractFileDataSource
implements CompositeDataSource,
ZipFileEntryParent {
    private static final Logger LOG = LoggerFactory.getLogger(ZipFileDataSource.class);
    private final Collection<DataSource> content = new ArrayList<DataSource>();
    private boolean contentLoaded = false;
    private ZipFile zipFile;

    public ZipFileDataSource(File file, FileType type) {
        super(file, type);
    }

    @Override
    public void close() {
        try {
            if (this.zipFile != null) {
                this.zipFile.close();
                this.zipFile = null;
            }
        }
        catch (IOException e) {
            LOG.error(this.path() + " close failed. Details: " + e.getLocalizedMessage(), (Throwable)e);
        }
    }

    @Override
    public boolean isWritable() {
        return false;
    }

    @Override
    public Collection<DataSource> content() {
        this.loadContent();
        return this.content;
    }

    @Override
    public DataSource entry(String name) {
        this.loadContent();
        return this.content.stream().filter(it -> it.name().equals(name)).findFirst().orElse(null);
    }

    ZipFile zipFile() {
        return this.zipFile;
    }

    @Override
    public InputStream entryStream(ZipEntry entry) {
        try {
            return this.zipFile.getInputStream(entry);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read " + this.path() + ": " + e.getLocalizedMessage(), e);
        }
    }

    private static Collection<DataSource> listZipEntries(ZipFileEntryParent parent, ZipFile zipFile) throws IOException, ZipException {
        ArrayList<DataSource> content = new ArrayList<DataSource>();
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            content.add(new ZipFileEntryDataSource(parent, entry));
        }
        return content;
    }

    private void loadContent() {
        if (this.contentLoaded) {
            return;
        }
        this.contentLoaded = true;
        try {
            this.zipFile = new ZipFile(this.file, 1);
            this.content.addAll(ZipFileDataSource.listZipEntries(this, this.zipFile));
        }
        catch (ZipException ze) {
            LOG.info("Failed to read {}: {}\nRetrying with cp437 charset just in case it was 'bad entry name'.\nConsider sticking to ASCII characters for file names.\nSee https://github.com/opentripplanner/OpenTripPlanner/pull/4835 for a discussion on this.", new Object[]{this.path(), ze.getLocalizedMessage(), ze});
            try {
                Charset charset = Charset.forName("Cp437");
                this.zipFile = new ZipFile(this.file, 1, charset);
                this.content.addAll(ZipFileDataSource.listZipEntries(this, this.zipFile));
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to load " + this.path() + ": " + e.getLocalizedMessage(), e);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load " + this.path() + ": " + e.getLocalizedMessage(), e);
        }
    }
}

