/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.datastore.file;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.stream.Stream;
import org.opentripplanner.datastore.api.CompositeDataSource;
import org.opentripplanner.datastore.api.DataSource;
import org.opentripplanner.datastore.api.FileType;
import org.opentripplanner.datastore.file.AbstractFileDataSource;
import org.opentripplanner.datastore.file.FileDataSource;

public class DirectoryDataSource
extends AbstractFileDataSource
implements CompositeDataSource {
    public DirectoryDataSource(File path, FileType type) {
        super(path, type);
    }

    @Override
    public Collection<DataSource> content() {
        ArrayList<DataSource> content = new ArrayList<DataSource>();
        if (this.file.exists()) {
            for (File file : this.file.listFiles()) {
                if (file.isDirectory()) continue;
                content.add(new FileDataSource(file, this.type));
            }
        }
        return content;
    }

    @Override
    public DataSource entry(String filename) {
        if (!this.file.exists()) {
            this.file.mkdirs();
        }
        return new FileDataSource(new File(this.file, filename), this.type);
    }

    @Override
    public void delete() {
        if (this.file.exists()) {
            try (Stream<Path> files = Files.walk(this.file.toPath(), new FileVisitOption[0]);){
                files.sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to delete " + this.path() + ": " + e.getLocalizedMessage(), e);
            }
        }
    }

    @Override
    public void close() {
    }
}

