/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.datastore.configure;

import dagger.Module;
import dagger.Provides;
import jakarta.inject.Singleton;
import java.io.File;
import java.util.ArrayList;
import javax.annotation.Nullable;
import org.opentripplanner.datastore.OtpDataStore;
import org.opentripplanner.datastore.api.CompositeDataSource;
import org.opentripplanner.datastore.api.FileType;
import org.opentripplanner.datastore.api.GoogleStorageDSRepository;
import org.opentripplanner.datastore.api.OtpBaseDirectory;
import org.opentripplanner.datastore.api.OtpDataStoreConfig;
import org.opentripplanner.datastore.base.DataSourceRepository;
import org.opentripplanner.datastore.file.FileDataSourceRepository;
import org.opentripplanner.datastore.https.HttpsDataSourceRepository;

@Module
public abstract class DataStoreModule {
    public static CompositeDataSource compositeSource(File file, FileType type) {
        return FileDataSourceRepository.compositeSource(file, type);
    }

    @Provides
    @Singleton
    public static OtpDataStore provideDataStore(@OtpBaseDirectory File baseDirectory, OtpDataStoreConfig config, @Nullable @GoogleStorageDSRepository DataSourceRepository gsRepository) {
        ArrayList<DataSourceRepository> repositories = new ArrayList<DataSourceRepository>();
        if (gsRepository != null) {
            repositories.add(gsRepository);
        }
        repositories.add(new HttpsDataSourceRepository());
        repositories.add(DataStoreModule.createFileDataSourceRepository(baseDirectory, config));
        OtpDataStore dataStore = new OtpDataStore(config, repositories);
        dataStore.open();
        return dataStore;
    }

    private static FileDataSourceRepository createFileDataSourceRepository(File baseDirectory, OtpDataStoreConfig config) {
        return new FileDataSourceRepository(baseDirectory, config.gtfsLocalFilePattern(), config.netexLocalFilePattern(), config.osmLocalFilePattern(), config.demLocalFilePattern());
    }
}

