/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.api.resource;

import org.locationtech.jts.geom.Envelope;

public class WebMercatorTile {
    public static Envelope tile2Envelope(int x, int y, int zoom) {
        double maxLat = WebMercatorTile.tile2lat(y, zoom);
        double minLat = WebMercatorTile.tile2lat(y + 1, zoom);
        double minLon = WebMercatorTile.tile2lon(x, zoom);
        double maxLon = WebMercatorTile.tile2lon(x + 1, zoom);
        return new Envelope(maxLon, minLon, maxLat, minLat);
    }

    private static double tile2lon(int x, int z) {
        return (double)x / Math.pow(2.0, z) * 360.0 - 180.0;
    }

    private static double tile2lat(int y, int z) {
        double n = Math.PI - Math.PI * 2 * (double)y / Math.pow(2.0, z);
        return Math.toDegrees(Math.atan(Math.sinh(n)));
    }
}

