/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.api.resource;

import jakarta.annotation.security.PermitAll;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import org.opentripplanner.api.model.ApiRouterInfo;
import org.opentripplanner.api.model.ApiRouterList;
import org.opentripplanner.routing.error.GraphNotFoundException;
import org.opentripplanner.standalone.api.OtpServerRequestContext;

@Path(value="/routers")
@PermitAll
public class Routers {
    private final OtpServerRequestContext serverContext;

    public Routers(@Context OtpServerRequestContext serverContext) {
        this.serverContext = serverContext;
    }

    @GET
    @Path(value="{ignoreRouterId}")
    @Produces(value={"application/json"})
    public ApiRouterInfo getGraphId(@PathParam(value="ignoreRouterId") String ignore) {
        return this.getRouterInfo();
    }

    @GET
    @Produces(value={"application/json"})
    public ApiRouterList getRouterIds() {
        ApiRouterList routerList = new ApiRouterList();
        routerList.routerInfo.add(this.getRouterInfo());
        return routerList;
    }

    private ApiRouterInfo getRouterInfo() {
        try {
            return new ApiRouterInfo("default", this.serverContext.graph(), this.serverContext.transitService(), this.serverContext.vehicleRentalService(), this.serverContext.worldEnvelopeService().envelope().orElseThrow());
        }
        catch (GraphNotFoundException e) {
            return null;
        }
    }
}

