/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.api.resource;

import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.CacheControl;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import javax.imageio.ImageIO;
import org.locationtech.jts.geom.Envelope;
import org.opentripplanner.api.parameter.MIMEImageFormat;
import org.opentripplanner.api.resource.InspectorLayersList;
import org.opentripplanner.api.resource.WebMercatorTile;
import org.opentripplanner.inspector.raster.MapTile;
import org.opentripplanner.standalone.api.OtpServerRequestContext;

@Path(value="/routers/{ignoreRouterId}/inspector")
public class GraphInspectorTileResource {
    private final OtpServerRequestContext serverContext;

    public GraphInspectorTileResource(@Context OtpServerRequestContext serverContext, @Deprecated @PathParam(value="ignoreRouterId") String ignoreRouterId) {
        this.serverContext = serverContext;
    }

    @GET
    @Path(value="/tile/{layer}/{z}/{x}/{y}.{ext}")
    @Produces(value={"image/*"})
    public Response tileGet(@PathParam(value="x") int x, @PathParam(value="y") int y, @PathParam(value="z") int z, @PathParam(value="layer") String layer, @PathParam(value="ext") String ext) throws Exception {
        Envelope env = WebMercatorTile.tile2Envelope(x, y, z);
        MapTile mapTile = new MapTile(env, 256, 256);
        OtpServerRequestContext serverContext = this.serverContext;
        BufferedImage image = serverContext.tileRendererManager().renderTile(mapTile, layer);
        MIMEImageFormat format = new MIMEImageFormat("image/" + ext);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(image.getWidth() * image.getHeight() / 4);
        ImageIO.write((RenderedImage)image, format.type, baos);
        CacheControl cc = new CacheControl();
        cc.setMaxAge(3600);
        cc.setNoCache(false);
        return Response.ok((Object)baos.toByteArray()).type(format.toString()).cacheControl(cc).build();
    }

    @GET
    @Path(value="layers")
    @Produces(value={"application/json"})
    public InspectorLayersList getLayers() {
        OtpServerRequestContext serverContext = this.serverContext;
        return new InspectorLayersList(serverContext.tileRendererManager().getRenderers());
    }
}

