/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.api.resource;

import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import org.locationtech.jts.geom.Envelope;
import org.opentripplanner.api.mapping.VehicleRentalStationMapper;
import org.opentripplanner.api.model.ApiVehicleRentalStation;
import org.opentripplanner.api.model.ApiVehicleRentalStationList;
import org.opentripplanner.service.vehiclerental.VehicleRentalService;
import org.opentripplanner.service.vehiclerental.model.VehicleRentalPlace;
import org.opentripplanner.standalone.api.OtpServerRequestContext;

@Path(value="/routers/{ignoreRouterId}/bike_rental")
public class BikeRental {
    private final OtpServerRequestContext serverContext;

    public BikeRental(@Deprecated @PathParam(value="ignoreRouterId") String ignoreRouterId, @Context OtpServerRequestContext serverContext) {
        this.serverContext = serverContext;
    }

    public static Envelope getEnvelope(String lowerLeft, String upperRight) {
        String[] lowerLeftParts = lowerLeft.split(",");
        String[] upperRightParts = upperRight.split(",");
        return new Envelope(Double.parseDouble(lowerLeftParts[1]), Double.parseDouble(upperRightParts[1]), Double.parseDouble(lowerLeftParts[0]), Double.parseDouble(upperRightParts[0]));
    }

    @GET
    @Produces(value={"application/json"})
    public ApiVehicleRentalStationList getBikeRentalStations(@QueryParam(value="lowerLeft") String lowerLeft, @QueryParam(value="upperRight") String upperRight, @QueryParam(value="locale") String locale_param) {
        Locale locale;
        OtpServerRequestContext serverContext = this.serverContext;
        VehicleRentalService vehicleRentalService = serverContext.vehicleRentalService();
        Locale locale2 = locale = locale_param != null && !locale_param.isBlank() ? Locale.forLanguageTag(locale_param.replaceAll("-", "_")) : Locale.ENGLISH;
        if (vehicleRentalService == null) {
            return new ApiVehicleRentalStationList();
        }
        Envelope envelope = lowerLeft != null ? BikeRental.getEnvelope(lowerLeft, upperRight) : new Envelope(-180.0, 180.0, -90.0, 90.0);
        Collection<VehicleRentalPlace> stations = vehicleRentalService.getVehicleRentalPlaces();
        ArrayList<ApiVehicleRentalStation> out = new ArrayList<ApiVehicleRentalStation>();
        for (VehicleRentalPlace station : stations) {
            if (!envelope.contains(station.getLongitude(), station.getLatitude())) continue;
            out.add(VehicleRentalStationMapper.mapToApi(station, locale));
        }
        ApiVehicleRentalStationList brsl = new ApiVehicleRentalStationList();
        brsl.stations = out;
        return brsl;
    }
}

