/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.api.mapping;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.opentripplanner.api.mapping.FeedScopedIdMapper;
import org.opentripplanner.api.mapping.I18NStringMapper;
import org.opentripplanner.api.mapping.WheelchairAccessibilityMapper;
import org.opentripplanner.api.model.ApiStop;
import org.opentripplanner.api.model.ApiStopShort;
import org.opentripplanner.transit.model.site.StopLocation;

public class StopMapper {
    public static List<ApiStop> mapToApi(Collection<StopLocation> domain) {
        if (domain == null) {
            return null;
        }
        return domain.stream().map(StopMapper::mapToApi).collect(Collectors.toList());
    }

    public static ApiStop mapToApi(StopLocation domain) {
        return StopMapper.mapToApi(domain, true);
    }

    public static ApiStop mapToApi(StopLocation domain, boolean extended) {
        if (domain == null) {
            return null;
        }
        ApiStop api = new ApiStop();
        api.id = FeedScopedIdMapper.mapToApi(domain.getId());
        api.lat = domain.getLat();
        api.lon = domain.getLon();
        api.code = domain.getCode();
        api.name = domain.getName().toString();
        if (extended) {
            String desc;
            api.desc = desc = domain.getDescription() != null ? domain.getDescription().toString() : null;
            api.zoneId = domain.getFirstZoneAsString();
            api.url = I18NStringMapper.mapToApi(domain.getUrl(), null);
            api.locationType = 0;
            api.stationId = FeedScopedIdMapper.mapIdToApi(domain.getParentStation());
            api.parentStation = StopMapper.mapToParentStationOldId(domain);
            api.wheelchairBoarding = WheelchairAccessibilityMapper.mapToApi(domain.getWheelchairAccessibility());
        }
        return api;
    }

    public static ApiStopShort mapToApiShort(StopLocation domain) {
        if (domain == null) {
            return null;
        }
        ApiStopShort api = new ApiStopShort();
        api.id = FeedScopedIdMapper.mapToApi(domain.getId());
        api.code = domain.getCode();
        api.name = domain.getName().toString();
        api.lat = domain.getLat();
        api.lon = domain.getLon();
        api.url = I18NStringMapper.mapToApi(domain.getUrl(), null);
        api.stationId = FeedScopedIdMapper.mapIdToApi(domain.getParentStation());
        api.cluster = StopMapper.mapToParentStationOldId(domain);
        return api;
    }

    public static ApiStopShort mapToApiShort(StopLocation domain, double distance) {
        if (domain == null) {
            return null;
        }
        ApiStopShort api = StopMapper.mapToApiShort(domain);
        api.dist = (int)distance;
        return api;
    }

    public static List<ApiStopShort> mapToApiShort(Collection<StopLocation> domain) {
        if (domain == null) {
            return null;
        }
        return domain.stream().map(StopMapper::mapToApiShort).toList();
    }

    private static String mapToParentStationOldId(StopLocation stop) {
        return stop.isPartOfStation() ? stop.getParentStation().getId().getId() : null;
    }
}

