/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.api.mapping;

import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;
import org.opentripplanner.api.mapping.FeedScopedIdMapper;
import org.opentripplanner.api.mapping.I18NStringMapper;
import org.opentripplanner.api.mapping.VertexTypeMapper;
import org.opentripplanner.api.model.ApiPlace;
import org.opentripplanner.api.model.ApiVehicleParkingSpaces;
import org.opentripplanner.api.model.ApiVehicleParkingWithEntrance;
import org.opentripplanner.model.plan.Place;
import org.opentripplanner.model.plan.StopArrival;
import org.opentripplanner.model.plan.VehicleParkingWithEntrance;
import org.opentripplanner.routing.vehicle_parking.VehicleParking;
import org.opentripplanner.routing.vehicle_parking.VehicleParkingEntrance;
import org.opentripplanner.routing.vehicle_parking.VehicleParkingSpaces;
import org.opentripplanner.transit.model.site.RegularStop;

public class PlaceMapper {
    private final Locale locale;
    private final I18NStringMapper i18NStringMapper;

    public PlaceMapper(Locale locale) {
        this.locale = locale;
        this.i18NStringMapper = new I18NStringMapper(this.locale);
    }

    public List<ApiPlace> mapStopArrivals(Collection<StopArrival> domain) {
        if (domain == null) {
            return null;
        }
        return domain.stream().map(this::mapStopArrival).collect(Collectors.toList());
    }

    public ApiPlace mapStopArrival(StopArrival domain) {
        return this.mapPlace(domain.place, domain.arrival, domain.departure, domain.stopPosInPattern, domain.gtfsStopSequence);
    }

    public ApiPlace mapPlace(Place domain, ZonedDateTime arrival, ZonedDateTime departure, Integer stopIndex, Integer gtfsStopSequence) {
        if (domain == null) {
            return null;
        }
        ApiPlace api = new ApiPlace();
        api.name = domain.name.toString(this.locale);
        if (domain.stop != null) {
            api.stopId = FeedScopedIdMapper.mapToApi(domain.stop.getId());
            api.stopCode = domain.stop.getCode();
            api.platformCode = domain.stop instanceof RegularStop ? ((RegularStop)domain.stop).getPlatformCode() : null;
            String string = api.zoneId = domain.stop instanceof RegularStop ? ((RegularStop)domain.stop).getFirstZoneAsString() : null;
        }
        if (domain.coordinate != null) {
            api.lon = domain.coordinate.longitude();
            api.lat = domain.coordinate.latitude();
        }
        api.arrival = Optional.ofNullable(arrival).map(GregorianCalendar::from).orElse(null);
        api.departure = Optional.ofNullable(departure).map(GregorianCalendar::from).orElse(null);
        api.stopIndex = stopIndex;
        api.stopSequence = gtfsStopSequence;
        api.vertexType = VertexTypeMapper.mapVertexType(domain.vertexType);
        if (domain.vehicleRentalPlace != null) {
            api.bikeShareId = domain.vehicleRentalPlace.getStationId();
            api.networks = List.of(domain.vehicleRentalPlace.getNetwork());
        }
        if (domain.vehicleParkingWithEntrance != null) {
            api.vehicleParking = this.mapVehicleParking(domain.vehicleParkingWithEntrance);
        }
        return api;
    }

    private static ApiVehicleParkingSpaces mapVehicleParkingSpaces(VehicleParkingSpaces parkingSpaces) {
        if (parkingSpaces == null) {
            return null;
        }
        return ApiVehicleParkingSpaces.builder().bicycleSpaces(parkingSpaces.getBicycleSpaces()).carSpaces(parkingSpaces.getCarSpaces()).wheelchairAccessibleCarSpaces(parkingSpaces.getWheelchairAccessibleCarSpaces()).build();
    }

    private ApiVehicleParkingWithEntrance mapVehicleParking(VehicleParkingWithEntrance vehicleParkingWithEntrance) {
        VehicleParking vp = vehicleParkingWithEntrance.getVehicleParking();
        VehicleParkingEntrance e = vehicleParkingWithEntrance.getEntrance();
        return ApiVehicleParkingWithEntrance.builder().id(FeedScopedIdMapper.mapToApi(vp.getId())).name(this.i18NStringMapper.mapToApi(vp.getName())).entranceId(FeedScopedIdMapper.mapToApi(e.getEntranceId())).entranceName(this.i18NStringMapper.mapToApi(e.getName())).note(this.i18NStringMapper.mapToApi(vp.getNote())).detailsUrl(vp.getDetailsUrl()).imageUrl(vp.getImageUrl()).tags(new ArrayList<String>(vp.getTags())).hasBicyclePlaces(vp.hasBicyclePlaces()).hasAnyCarPlaces(vp.hasAnyCarPlaces()).hasCarPlaces(vp.hasCarPlaces()).hasWheelchairAccessibleCarPlaces(vp.hasWheelchairAccessibleCarPlaces()).availability(PlaceMapper.mapVehicleParkingSpaces(vp.getAvailability())).capacity(PlaceMapper.mapVehicleParkingSpaces(vp.getCapacity())).realtime(vehicleParkingWithEntrance.isRealtime()).build();
    }
}

