/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.api.mapping;

import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import org.locationtech.jts.geom.Geometry;
import org.opentripplanner.api.mapping.AlertMapper;
import org.opentripplanner.api.mapping.BookingInfoMapper;
import org.opentripplanner.api.mapping.ElevationMapper;
import org.opentripplanner.api.mapping.FeedScopedIdMapper;
import org.opentripplanner.api.mapping.I18NStringMapper;
import org.opentripplanner.api.mapping.LocalDateMapper;
import org.opentripplanner.api.mapping.ModeMapper;
import org.opentripplanner.api.mapping.PlaceMapper;
import org.opentripplanner.api.mapping.StreetNoteMaperMapper;
import org.opentripplanner.api.mapping.WalkStepMapper;
import org.opentripplanner.api.model.ApiAlert;
import org.opentripplanner.api.model.ApiLeg;
import org.opentripplanner.framework.geometry.EncodedPolyline;
import org.opentripplanner.model.PickDrop;
import org.opentripplanner.model.plan.Leg;
import org.opentripplanner.model.plan.StreetLeg;
import org.opentripplanner.model.plan.TransitLeg;
import org.opentripplanner.transit.model.network.Route;
import org.opentripplanner.transit.model.organization.Agency;
import org.opentripplanner.transit.model.timetable.Trip;

public class LegMapper {
    private final WalkStepMapper walkStepMapper;
    private final StreetNoteMaperMapper streetNoteMaperMapper;
    private final AlertMapper alertMapper;
    private final PlaceMapper placeMapper;
    private final boolean addIntermediateStops;
    private final I18NStringMapper i18NStringMapper;

    public LegMapper(Locale locale, boolean addIntermediateStops) {
        this.walkStepMapper = new WalkStepMapper(locale);
        this.streetNoteMaperMapper = new StreetNoteMaperMapper(locale);
        this.alertMapper = new AlertMapper(locale);
        this.placeMapper = new PlaceMapper(locale);
        this.addIntermediateStops = addIntermediateStops;
        this.i18NStringMapper = new I18NStringMapper(locale);
    }

    public List<ApiLeg> mapLegs(List<Leg> domain) {
        if (domain == null) {
            return null;
        }
        ArrayList<ApiLeg> apiLegs = new ArrayList<ApiLeg>();
        int size = domain.size();
        int lastIdx = size - 1;
        for (int i = 0; i < size; ++i) {
            ZonedDateTime arrivalTimeFromPlace = i == 0 ? null : domain.get(i - 1).getEndTime();
            ZonedDateTime departureTimeToPlace = i == lastIdx ? null : domain.get(i + 1).getStartTime();
            apiLegs.add(this.mapLeg(domain.get(i), arrivalTimeFromPlace, departureTimeToPlace));
        }
        return apiLegs;
    }

    public ApiLeg mapLeg(Leg domain, ZonedDateTime arrivalTimeFromPlace, ZonedDateTime departureTimeToPlace) {
        if (domain == null) {
            return null;
        }
        ApiLeg api = new ApiLeg();
        api.startTime = GregorianCalendar.from(domain.getStartTime());
        api.endTime = GregorianCalendar.from(domain.getEndTime());
        api.from = this.placeMapper.mapPlace(domain.getFrom(), arrivalTimeFromPlace, domain.getStartTime(), domain.getBoardStopPosInPattern(), domain.getBoardingGtfsStopSequence());
        api.to = this.placeMapper.mapPlace(domain.getTo(), domain.getEndTime(), departureTimeToPlace, domain.getAlightStopPosInPattern(), domain.getAlightGtfsStopSequence());
        api.departureDelay = domain.getDepartureDelay();
        api.arrivalDelay = domain.getArrivalDelay();
        api.realTime = domain.getRealTime();
        api.isNonExactFrequency = domain.getNonExactFrequency();
        api.headway = domain.getHeadway();
        api.distance = this.round3Decimals(domain.getDistanceMeters());
        api.generalizedCost = domain.getGeneralizedCost();
        api.pathway = domain.getPathwayId() != null;
        api.agencyTimeZoneOffset = domain.getAgencyTimeZoneOffset();
        if (domain instanceof TransitLeg) {
            TransitLeg trLeg = (TransitLeg)domain;
            api.transitLeg = true;
            Agency agency = domain.getAgency();
            api.agencyId = FeedScopedIdMapper.mapToApi(agency.getId());
            api.agencyName = agency.getName();
            api.agencyUrl = agency.getUrl();
            api.agencyBrandingUrl = agency.getBrandingUrl();
            api.mode = ModeMapper.mapToApi(trLeg.getMode());
            Route route = domain.getRoute();
            api.route = this.i18NStringMapper.mapToApi(route.getLongName());
            api.routeColor = route.getColor();
            api.routeType = domain.getRouteType();
            api.routeId = FeedScopedIdMapper.mapToApi(route.getId());
            api.routeShortName = route.getShortName();
            api.routeLongName = this.i18NStringMapper.mapToApi(route.getLongName());
            api.routeTextColor = route.getTextColor();
            Trip trip = domain.getTrip();
            api.tripId = FeedScopedIdMapper.mapToApi(trip.getId());
            api.tripShortName = trip.getShortName();
            api.tripBlockId = trip.getGtfsBlockId();
        } else if (domain instanceof StreetLeg) {
            StreetLeg streetLeg = (StreetLeg)domain;
            api.transitLeg = false;
            api.mode = ModeMapper.mapToApi(streetLeg.getMode());
            api.route = domain.getPathwayId() != null ? FeedScopedIdMapper.mapToApi(domain.getPathwayId()) : "";
        }
        api.interlineWithPreviousLeg = domain.isInterlinedWithPreviousLeg();
        api.headsign = this.i18NStringMapper.mapToApi(domain.getHeadsign());
        api.serviceDate = LocalDateMapper.mapToApi(domain.getServiceDate());
        api.routeBrandingUrl = domain.getRouteBrandingUrl();
        if (this.addIntermediateStops) {
            api.intermediateStops = this.placeMapper.mapStopArrivals(domain.getIntermediateStops());
        }
        api.legGeometry = EncodedPolyline.encode((Geometry)domain.getLegGeometry());
        api.legElevation = ElevationMapper.mapElevation(domain.getElevationProfile());
        api.steps = this.walkStepMapper.mapWalkSteps(domain.getWalkSteps());
        api.alerts = LegMapper.concatenateAlerts(this.streetNoteMaperMapper.mapToApi(domain.getStreetNotes()), this.alertMapper.mapToApi(domain.getTransitAlerts()));
        api.boardRule = LegMapper.getBoardAlightMessage(domain.getBoardRule());
        api.alightRule = LegMapper.getBoardAlightMessage(domain.getAlightRule());
        api.pickupBookingInfo = BookingInfoMapper.mapBookingInfo(domain.getPickupBookingInfo(), true);
        api.dropOffBookingInfo = BookingInfoMapper.mapBookingInfo(domain.getDropOffBookingInfo(), false);
        api.rentedBike = domain.getRentedVehicle();
        api.walkingBike = domain.getWalkingBike();
        api.accessibilityScore = domain.accessibilityScore();
        return api;
    }

    private Double round3Decimals(double value) {
        return (double)Math.round(value * 1000.0) / 1000.0;
    }

    private static String getBoardAlightMessage(PickDrop boardAlightType) {
        if (boardAlightType == null) {
            return null;
        }
        switch (boardAlightType) {
            case NONE: {
                return "impossible";
            }
            case CALL_AGENCY: {
                return "mustPhone";
            }
            case COORDINATE_WITH_DRIVER: {
                return "coordinateWithDriver";
            }
        }
        return null;
    }

    private static List<ApiAlert> concatenateAlerts(List<ApiAlert> a, List<ApiAlert> b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        ArrayList<ApiAlert> ret = new ArrayList<ApiAlert>(a);
        ret.addAll(b);
        return ret;
    }
}

