/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.api.common;

import com.fasterxml.jackson.databind.JsonNode;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MultivaluedMap;
import java.time.Duration;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.opentripplanner.api.common.LocationStringParser;
import org.opentripplanner.api.common.RequestToPreferencesMapper;
import org.opentripplanner.api.parameter.QualifiedModeSet;
import org.opentripplanner.ext.dataoverlay.api.DataOverlayParameters;
import org.opentripplanner.framework.application.OTPFeature;
import org.opentripplanner.framework.lang.StringUtils;
import org.opentripplanner.routing.api.request.DebugRaptor;
import org.opentripplanner.routing.api.request.RouteRequest;
import org.opentripplanner.routing.api.request.preference.RoutingPreferences;
import org.opentripplanner.routing.api.request.request.JourneyRequest;
import org.opentripplanner.routing.api.request.request.TransitRequest;
import org.opentripplanner.routing.api.request.request.VehicleParkingRequest;
import org.opentripplanner.routing.api.request.request.VehicleRentalRequest;
import org.opentripplanner.routing.api.request.request.filter.SelectRequest;
import org.opentripplanner.routing.api.request.request.filter.TransitFilterRequest;
import org.opentripplanner.routing.api.request.request.filter.VehicleParkingFilter;
import org.opentripplanner.routing.api.request.request.filter.VehicleParkingFilterRequest;
import org.opentripplanner.routing.core.BicycleOptimizeType;
import org.opentripplanner.standalone.api.OtpServerRequestContext;
import org.opentripplanner.standalone.config.framework.file.ConfigFileLoader;
import org.opentripplanner.standalone.config.framework.json.NodeAdapter;
import org.opentripplanner.standalone.config.routerequest.RouteRequestConfig;
import org.opentripplanner.transit.model.basic.MainAndSubMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RoutingResource {
    private static final Logger LOG = LoggerFactory.getLogger(RoutingResource.class);
    @QueryParam(value="fromPlace")
    protected String fromPlace;
    @QueryParam(value="toPlace")
    protected String toPlace;
    @Deprecated
    @QueryParam(value="intermediatePlaces")
    protected List<String> intermediatePlaces;
    @QueryParam(value="date")
    protected String date;
    @QueryParam(value="time")
    protected String time;
    @QueryParam(value="searchWindow")
    protected Integer searchWindow;
    @QueryParam(value="pageCursor")
    public String pageCursor;
    @QueryParam(value="timetableView")
    public Boolean timetableView;
    @Deprecated
    @QueryParam(value="arriveBy")
    protected Boolean arriveBy;
    @Deprecated
    @QueryParam(value="wheelchair")
    protected Boolean wheelchair;
    @Deprecated
    @QueryParam(value="maxPreTransitTime")
    protected Integer maxPreTransitTime;
    @QueryParam(value="bikeWalkingReluctance")
    protected Double bikeWalkingReluctance;
    @QueryParam(value="walkReluctance")
    protected Double walkReluctance;
    @QueryParam(value="bikeReluctance")
    protected Double bikeReluctance;
    @QueryParam(value="carReluctance")
    protected Double carReluctance;
    @QueryParam(value="waitReluctance")
    protected Double waitReluctance;
    @QueryParam(value="walkSpeed")
    protected Double walkSpeed;
    @QueryParam(value="bikeSpeed")
    protected Double bikeSpeed;
    @QueryParam(value="bikeWalkingSpeed")
    protected Double bikeWalkingSpeed;
    @QueryParam(value="bikeSwitchTime")
    protected Integer bikeSwitchTime;
    @QueryParam(value="bikeSwitchCost")
    protected Integer bikeSwitchCost;
    @QueryParam(value="triangleSafetyFactor")
    protected Double triangleSafetyFactor;
    @QueryParam(value="triangleSlopeFactor")
    protected Double triangleSlopeFactor;
    @QueryParam(value="triangleTimeFactor")
    protected Double triangleTimeFactor;
    @Deprecated
    @QueryParam(value="optimize")
    protected BicycleOptimizeType bikeOptimizeType;
    @QueryParam(value="mode")
    protected QualifiedModeSet modes;
    @Deprecated
    @QueryParam(value="minTransferTime")
    protected Integer minTransferTime;
    @QueryParam(value="numItineraries")
    protected Integer numItineraries;
    @Deprecated
    @QueryParam(value="preferredAgencies")
    protected String preferredAgencies;
    @Deprecated
    @QueryParam(value="unpreferredAgencies")
    protected String unpreferredAgencies;
    @QueryParam(value="bannedAgencies")
    protected String bannedAgencies;
    @QueryParam(value="whiteListedAgencies")
    protected String whiteListedAgencies;
    @QueryParam(value="showIntermediateStops")
    @DefaultValue(value="false")
    protected Boolean showIntermediateStops;
    @QueryParam(value="walkBoardCost")
    protected Integer walkBoardCost;
    @QueryParam(value="bikeBoardCost")
    protected Integer bikeBoardCost;
    @QueryParam(value="walkSafetyFactor")
    protected Double walkSafetyFactor;
    @QueryParam(value="allowKeepingRentedBicycleAtDestination")
    protected Boolean allowKeepingRentedBicycleAtDestination;
    @QueryParam(value="keepingRentedBicycleAtDestinationCost")
    protected Double keepingRentedBicycleAtDestinationCost;
    @QueryParam(value="allowedVehicleRentalNetworks")
    protected Set<String> allowedVehicleRentalNetworks;
    @QueryParam(value="bannedVehicleRentalNetworks")
    protected Set<String> bannedVehicleRentalNetworks;
    @QueryParam(value="bikeParkTime")
    protected Integer bikeParkTime;
    @QueryParam(value="bikeParkCost")
    protected Integer bikeParkCost;
    @QueryParam(value="carParkTime")
    protected Integer carParkTime = 60;
    @QueryParam(value="carParkCost")
    protected Integer carParkCost = 120;
    @QueryParam(value="requiredVehicleParkingTags")
    protected Set<String> requiredVehicleParkingTags = Set.of();
    @QueryParam(value="bannedVehicleParkingTags")
    protected Set<String> bannedVehicleParkingTags = Set.of();
    @Deprecated
    @QueryParam(value="bannedRoutes")
    protected String bannedRoutes;
    @QueryParam(value="whiteListedRoutes")
    @Deprecated
    protected String whiteListedRoutes;
    @Deprecated
    @QueryParam(value="preferredRoutes")
    protected String preferredRoutes;
    @Deprecated
    @QueryParam(value="unpreferredRoutes")
    protected String unpreferredRoutes;
    @Deprecated
    @QueryParam(value="otherThanPreferredRoutesPenalty")
    protected Integer otherThanPreferredRoutesPenalty;
    @QueryParam(value="bannedTrips")
    protected String bannedTrips;
    @Deprecated
    @QueryParam(value="bannedStops")
    protected String bannedStops;
    @Deprecated
    @QueryParam(value="bannedStopsHard")
    protected String bannedStopsHard;
    @QueryParam(value="transferPenalty")
    protected Integer transferPenalty;
    @Deprecated
    @QueryParam(value="nonpreferredTransferPenalty")
    protected Integer nonpreferredTransferPenalty;
    @Deprecated
    @QueryParam(value="maxTransfers")
    protected Integer maxTransfers;
    @QueryParam(value="maxAdditionalTransfers")
    protected Integer maxAdditionalTransfers;
    @Deprecated
    @QueryParam(value="batch")
    protected Boolean batch;
    @Deprecated
    @QueryParam(value="startTransitStopId")
    protected String startTransitStopId;
    @Deprecated
    @QueryParam(value="startTransitTripId")
    protected String startTransitTripId;
    @Deprecated
    @QueryParam(value="clampInitialWait")
    protected Long clampInitialWait;
    @Deprecated
    @QueryParam(value="reverseOptimizeOnTheFly")
    protected Boolean reverseOptimizeOnTheFly;
    @QueryParam(value="boardSlack")
    protected Integer boardSlack;
    @QueryParam(value="alightSlack")
    protected Integer alightSlack;
    @QueryParam(value="locale")
    private String locale;
    @Deprecated
    @QueryParam(value="ignoreRealtimeUpdates")
    protected Boolean ignoreRealtimeUpdates;
    @QueryParam(value="disableRemainingWeightHeuristic")
    protected Boolean disableRemainingWeightHeuristic;
    @Deprecated
    @QueryParam(value="maxHours")
    private Double maxHours;
    @QueryParam(value="useRequestedDateTimeInMaxHours")
    @Deprecated
    private Boolean useRequestedDateTimeInMaxHours;
    @QueryParam(value="disableAlertFiltering")
    @Deprecated
    private Boolean disableAlertFiltering;
    @QueryParam(value="debugItineraryFilter")
    protected Boolean debugItineraryFilter;
    @QueryParam(value="groupSimilarityKeepOne")
    Double groupSimilarityKeepOne;
    @QueryParam(value="groupSimilarityKeepThree")
    Double groupSimilarityKeepThree;
    @QueryParam(value="groupedOtherThanSameLegsMaxCostMultiplier")
    Double groupedOtherThanSameLegsMaxCostMultiplier;
    @QueryParam(value="transitGeneralizedCostLimitFunction")
    String transitGeneralizedCostLimitFunction;
    @QueryParam(value="transitGeneralizedCostLimitIntervalRelaxFactor")
    Double transitGeneralizedCostLimitIntervalRelaxFactor;
    @QueryParam(value="nonTransitGeneralizedCostLimitFunction")
    String nonTransitGeneralizedCostLimitFunction;
    @QueryParam(value="geoidElevation")
    protected Boolean geoidElevation;
    @QueryParam(value="useVehicleParkingAvailabilityInformation")
    protected Boolean useVehicleParkingAvailabilityInformation;
    @QueryParam(value="relaxTransitSearchGeneralizedCostAtDestination")
    protected Double relaxTransitSearchGeneralizedCostAtDestination;
    @QueryParam(value="debugRaptorStops")
    private String debugRaptorStops;
    @QueryParam(value="debugRaptorPath")
    private String debugRaptorPath;
    @QueryParam(value="config")
    private String config;
    @Context
    protected OtpServerRequestContext serverContext;

    protected RouteRequest buildRequest(MultivaluedMap<String, String> queryParameters) {
        RouteRequest request = this.defaultRouteRequest();
        RequestToPreferencesMapper.setIfNotNull(this.fromPlace, it -> request.setFrom(LocationStringParser.fromOldStyleString(it)));
        RequestToPreferencesMapper.setIfNotNull(this.toPlace, it -> request.setTo(LocationStringParser.fromOldStyleString(it)));
        ZoneId tz = this.serverContext.transitService().getTimeZone();
        if (this.date == null && this.time != null) {
            LOG.debug("parsing ISO datetime {}", (Object)this.time);
            try {
                DatatypeFactory df = DatatypeFactory.newInstance();
                XMLGregorianCalendar xmlGregCal = df.newXMLGregorianCalendar(this.time);
                ZonedDateTime dateTime = xmlGregCal.toGregorianCalendar().toZonedDateTime();
                if (xmlGregCal.getTimezone() == Integer.MIN_VALUE) {
                    dateTime = dateTime.withZoneSameLocal(tz);
                }
                request.setDateTime(dateTime.toInstant());
            }
            catch (DatatypeConfigurationException e) {
                request.setDateTime(this.date, this.time, tz);
            }
        } else {
            request.setDateTime(this.date, this.time, tz);
        }
        RequestToPreferencesMapper.setIfNotNull(this.searchWindow, it -> request.setSearchWindow(Duration.ofSeconds(it.intValue())));
        RequestToPreferencesMapper.setIfNotNull(this.pageCursor, request::setPageCursorFromEncoded);
        RequestToPreferencesMapper.setIfNotNull(this.timetableView, request::setTimetableView);
        RequestToPreferencesMapper.setIfNotNull(this.wheelchair, request::setWheelchair);
        RequestToPreferencesMapper.setIfNotNull(this.numItineraries, request::setNumItineraries);
        JourneyRequest journey = request.journey();
        if (this.modes != null && !this.modes.qModes.isEmpty()) {
            journey.setModes(this.modes.getRequestModes());
        }
        VehicleRentalRequest rental = journey.rental();
        RequestToPreferencesMapper.setIfNotNull(this.allowKeepingRentedBicycleAtDestination, rental::setAllowArrivingInRentedVehicleAtDestination);
        RequestToPreferencesMapper.setIfNotNull(this.allowedVehicleRentalNetworks, rental::setAllowedNetworks);
        RequestToPreferencesMapper.setIfNotNull(this.bannedVehicleRentalNetworks, rental::setBannedNetworks);
        VehicleParkingRequest parking = journey.parking();
        RequestToPreferencesMapper.setIfNotNull(this.useVehicleParkingAvailabilityInformation, parking::setUseAvailabilityInformation);
        parking.setFilter(new VehicleParkingFilterRequest(new VehicleParkingFilter.TagsFilter(this.bannedVehicleParkingTags), new VehicleParkingFilter.TagsFilter(this.requiredVehicleParkingTags)));
        RequestToPreferencesMapper.setIfNotNull(this.arriveBy, request::setArriveBy);
        TransitRequest transit = journey.transit();
        TransitFilterRequest.Builder filterBuilder = TransitFilterRequest.of();
        RequestToPreferencesMapper.setIfNotNull(this.preferredAgencies, transit::setPreferredAgenciesFromString);
        RequestToPreferencesMapper.setIfNotNull(this.unpreferredAgencies, transit::setUnpreferredAgenciesFromString);
        RequestToPreferencesMapper.setIfNotNull(this.preferredRoutes, transit::setPreferredRoutesFromString);
        RequestToPreferencesMapper.setIfNotNull(this.unpreferredRoutes, transit::setUnpreferredRoutesFromString);
        RequestToPreferencesMapper.setIfNotNull(this.bannedTrips, journey.transit()::setBannedTripsFromString);
        RequestToPreferencesMapper.setIfNotNull(this.bannedAgencies, s -> filterBuilder.addNot(SelectRequest.of().withAgenciesFromString((String)s).build()));
        RequestToPreferencesMapper.setIfNotNull(this.bannedRoutes, s -> filterBuilder.addNot(SelectRequest.of().withRoutesFromString((String)s).build()));
        ArrayList selectors = new ArrayList();
        RequestToPreferencesMapper.setIfNotNull(this.whiteListedAgencies, s -> selectors.add(SelectRequest.of().withAgenciesFromString((String)s)));
        RequestToPreferencesMapper.setIfNotNull(this.whiteListedRoutes, s -> selectors.add(SelectRequest.of().withRoutesFromString((String)s)));
        List<MainAndSubMode> tModes = this.modes == null ? MainAndSubMode.all() : this.modes.getTransitModes().stream().map(MainAndSubMode::new).toList();
        if (!selectors.isEmpty()) {
            for (SelectRequest.Builder selector : selectors) {
                filterBuilder.addSelect(selector.withTransportModes(tModes).build());
            }
        } else {
            filterBuilder.addSelect(SelectRequest.of().withTransportModes(tModes).build());
        }
        if (tModes.isEmpty()) {
            transit.disable();
        } else {
            transit.setFilters(List.of(filterBuilder.build()));
        }
        DebugRaptor debugRaptor = journey.transit().raptorDebugging();
        RequestToPreferencesMapper.setIfNotNull(this.debugRaptorStops, debugRaptor::withStops);
        RequestToPreferencesMapper.setIfNotNull(this.debugRaptorPath, debugRaptor::withPath);
        if (this.locale != null) {
            request.setLocale(Locale.forLanguageTag(this.locale.replaceAll("-", "_")));
        }
        request.withPreferences(preferences -> {
            DataOverlayParameters dataOverlayParameters;
            new RequestToPreferencesMapper(this, (RoutingPreferences.Builder)preferences, request.isTripPlannedForNow()).map();
            if (OTPFeature.DataOverlay.isOn() && !(dataOverlayParameters = DataOverlayParameters.parseQueryParams((Map<String, List<String>>)queryParameters)).isEmpty()) {
                preferences.withSystem(it -> it.withDataOverlay(dataOverlayParameters));
            }
        });
        return request;
    }

    private RouteRequest defaultRouteRequest() {
        RouteRequest request = this.serverContext.defaultRouteRequest();
        if (OTPFeature.RestAPIPassInDefaultConfigAsJson.isOn() && StringUtils.hasValue(this.config)) {
            String source = "Request.config";
            JsonNode root = ConfigFileLoader.nodeFromString(this.config, source);
            return RouteRequestConfig.mapRouteRequest(new NodeAdapter(root, source), request);
        }
        return request;
    }
}

