/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.api.common;

import jakarta.validation.constraints.NotNull;
import java.util.function.Consumer;
import org.opentripplanner.api.common.RoutingResource;
import org.opentripplanner.routing.algorithm.filterchain.api.TransitGeneralizedCostFilterParams;
import org.opentripplanner.routing.api.request.framework.RequestFunctions;
import org.opentripplanner.routing.api.request.preference.ItineraryFilterPreferences;
import org.opentripplanner.routing.api.request.preference.RoutingPreferences;
import org.opentripplanner.routing.core.BicycleOptimizeType;

class RequestToPreferencesMapper {
    private final RoutingResource req;
    private final RoutingPreferences.Builder preferences;
    private final boolean isPlannedForNow;

    RequestToPreferencesMapper(RoutingResource req, RoutingPreferences.Builder preferences, boolean isPlannedForNow) {
        this.req = req;
        this.preferences = preferences;
        this.isPlannedForNow = isPlannedForNow;
    }

    void map() {
        this.mapCar();
        this.mapWalk();
        this.mapBike();
        BoardAndAlightSlack boardAndAlightSlack = this.mapTransit();
        this.mapTransfer(boardAndAlightSlack);
        this.maptRental();
        this.mapItineraryFilter();
        this.mapSystem();
    }

    private void mapCar() {
        this.preferences.withCar(car -> {
            RequestToPreferencesMapper.setIfNotNull(this.req.carReluctance, car::withReluctance);
            RequestToPreferencesMapper.setIfNotNull(this.req.carParkCost, car::withParkCost);
            RequestToPreferencesMapper.setIfNotNull(this.req.carParkTime, car::withParkTime);
        });
    }

    private void mapWalk() {
        this.preferences.withWalk(walk -> {
            RequestToPreferencesMapper.setIfNotNull(this.req.walkReluctance, walk::withReluctance);
            RequestToPreferencesMapper.setIfNotNull(this.req.walkSpeed, walk::withSpeed);
            RequestToPreferencesMapper.setIfNotNull(this.req.walkBoardCost, walk::withBoardCost);
            RequestToPreferencesMapper.setIfNotNull(this.req.walkSafetyFactor, walk::withSafetyFactor);
        });
    }

    private void mapBike() {
        this.preferences.withBike(bike -> {
            RequestToPreferencesMapper.setIfNotNull(this.req.bikeSpeed, bike::withSpeed);
            RequestToPreferencesMapper.setIfNotNull(this.req.bikeReluctance, bike::withReluctance);
            RequestToPreferencesMapper.setIfNotNull(this.req.bikeBoardCost, bike::withBoardCost);
            RequestToPreferencesMapper.setIfNotNull(this.req.bikeWalkingSpeed, bike::withWalkingSpeed);
            RequestToPreferencesMapper.setIfNotNull(this.req.bikeWalkingReluctance, bike::withWalkingReluctance);
            RequestToPreferencesMapper.setIfNotNull(this.req.bikeParkCost, bike::withParkCost);
            RequestToPreferencesMapper.setIfNotNull(this.req.bikeParkTime, bike::withParkTime);
            RequestToPreferencesMapper.setIfNotNull(this.req.bikeSwitchTime, bike::withSwitchTime);
            RequestToPreferencesMapper.setIfNotNull(this.req.bikeSwitchCost, bike::withSwitchCost);
            RequestToPreferencesMapper.setIfNotNull(this.req.bikeOptimizeType, bike::withOptimizeType);
            if (this.req.bikeOptimizeType == BicycleOptimizeType.TRIANGLE) {
                bike.withOptimizeTriangle(triangle -> {
                    RequestToPreferencesMapper.setIfNotNull(this.req.triangleTimeFactor, triangle::withTime);
                    RequestToPreferencesMapper.setIfNotNull(this.req.triangleSlopeFactor, triangle::withSlope);
                    RequestToPreferencesMapper.setIfNotNull(this.req.triangleSafetyFactor, triangle::withSafety);
                });
            }
        });
    }

    private BoardAndAlightSlack mapTransit() {
        this.preferences.withTransit(tr -> {
            RequestToPreferencesMapper.setIfNotNull(this.req.boardSlack, tr::withDefaultBoardSlackSec);
            RequestToPreferencesMapper.setIfNotNull(this.req.alightSlack, tr::withDefaultAlightSlackSec);
            RequestToPreferencesMapper.setIfNotNull(this.req.otherThanPreferredRoutesPenalty, tr::setOtherThanPreferredRoutesPenalty);
            RequestToPreferencesMapper.setIfNotNull(this.req.ignoreRealtimeUpdates, tr::setIgnoreRealtimeUpdates);
            RequestToPreferencesMapper.setIfNotNull(this.req.relaxTransitSearchGeneralizedCostAtDestination, value -> tr.withRaptor(it -> it.withRelaxGeneralizedCostAtDestination((Double)value)));
        });
        return new BoardAndAlightSlack(this.preferences.transit().boardSlack().defaultValueSeconds() + this.preferences.transit().alightSlack().defaultValueSeconds());
    }

    private void mapTransfer(BoardAndAlightSlack boardAndAlightSlack) {
        this.preferences.withTransfer(transfer -> {
            RequestToPreferencesMapper.setIfNotNull(this.req.waitReluctance, transfer::withWaitReluctance);
            RequestToPreferencesMapper.setIfNotNull(this.req.transferPenalty, transfer::withCost);
            if (this.req.minTransferTime != null) {
                if (boardAndAlightSlack.value > this.req.minTransferTime) {
                    throw new IllegalArgumentException("Invalid parameters: 'minTransferTime' must be greater than or equal to board slack plus alight slack");
                }
                transfer.withSlack(this.req.minTransferTime - boardAndAlightSlack.value);
            }
            RequestToPreferencesMapper.setIfNotNull(this.req.nonpreferredTransferPenalty, transfer::withNonpreferredCost);
            RequestToPreferencesMapper.setIfNotNull(this.req.maxTransfers, transfer::withMaxTransfers);
            RequestToPreferencesMapper.setIfNotNull(this.req.maxAdditionalTransfers, transfer::withMaxAdditionalTransfers);
        });
    }

    private void maptRental() {
        this.preferences.withRental(rental -> {
            RequestToPreferencesMapper.setIfNotNull(this.req.keepingRentedBicycleAtDestinationCost, rental::withArrivingInRentalVehicleAtDestinationCost);
            rental.withUseAvailabilityInformation(this.isPlannedForNow);
        });
    }

    private void mapItineraryFilter() {
        this.preferences.withItineraryFilter(filter -> {
            RequestToPreferencesMapper.setIfNotNull(this.req.debugItineraryFilter, filter::withDebug);
            RequestToPreferencesMapper.setIfNotNull(this.req.groupSimilarityKeepOne, filter::withGroupSimilarityKeepOne);
            RequestToPreferencesMapper.setIfNotNull(this.req.groupSimilarityKeepThree, filter::withGroupSimilarityKeepThree);
            RequestToPreferencesMapper.setIfNotNull(this.req.groupedOtherThanSameLegsMaxCostMultiplier, filter::withGroupedOtherThanSameLegsMaxCostMultiplier);
            filter.withTransitGeneralizedCostLimit(this.mapTransitGeneralizedCostFilterParams((ItineraryFilterPreferences.Builder)filter));
            RequestToPreferencesMapper.setIfNotNull(this.req.nonTransitGeneralizedCostLimitFunction, it -> filter.withNonTransitGeneralizedCostLimit(RequestFunctions.parse(it)));
        });
    }

    private TransitGeneralizedCostFilterParams mapTransitGeneralizedCostFilterParams(ItineraryFilterPreferences.Builder filter) {
        TransitGeneralizedCostFilterParams result = filter.original().transitGeneralizedCostLimit();
        if (this.req.transitGeneralizedCostLimitFunction != null) {
            result = new TransitGeneralizedCostFilterParams(RequestFunctions.parse(this.req.transitGeneralizedCostLimitFunction), result.intervalRelaxFactor());
        }
        if (this.req.transitGeneralizedCostLimitIntervalRelaxFactor != null) {
            result = new TransitGeneralizedCostFilterParams(result.costLimitFunction(), this.req.transitGeneralizedCostLimitIntervalRelaxFactor);
        }
        return result;
    }

    private void mapSystem() {
        this.preferences.withSystem(system -> RequestToPreferencesMapper.setIfNotNull(this.req.geoidElevation, system::withGeoidElevation));
    }

    static <T> void setIfNotNull(T value, @NotNull Consumer<T> body) {
        if (value != null) {
            body.accept(value);
        }
    }

    private record BoardAndAlightSlack(int value) {
    }
}

