/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.util.time;

import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.opentripplanner.util.time.RelativeTime;

public class TimeUtils {
    public static final int NOT_SET = -1000000;
    private static final Pattern DAYS_SUFFIX = Pattern.compile("([-+])(\\d+)d");
    public static final Integer ONE_DAY_SECONDS = 86400;

    private TimeUtils() {
    }

    public static int hms2time(int hour, int minute, int second) {
        return second + 60 * (minute + 60 * hour);
    }

    public static int hm2time(int hour, int minute) {
        return TimeUtils.hms2time(hour, minute, 0);
    }

    public static int time(String hhmmss) {
        String[] tokens;
        Matcher m;
        int days = 0;
        boolean negative = hhmmss.startsWith("-");
        if (negative) {
            hhmmss = hhmmss.substring(1);
        }
        if ((m = DAYS_SUFFIX.matcher(hhmmss)).find()) {
            days = Integer.parseInt(m.group(2));
            if ("-".equals(m.group(1))) {
                days = -days;
            }
            tokens = hhmmss.substring(0, m.start()).split(":");
        } else {
            tokens = hhmmss.split(":");
        }
        if (tokens.length > 3 || tokens.length < 1) {
            throw new IllegalStateException("Parse error, not a valid time (HH|HH:MM|HH:MM:SS): '" + hhmmss + "'");
        }
        int hh = Integer.parseInt(tokens[0]);
        if (hh > 23) {
            days += hh / 24;
            hh %= 24;
        }
        int mm = tokens.length > 1 ? Integer.parseInt(tokens[1]) : 0;
        int ss = tokens.length == 3 ? Integer.parseInt(tokens[2]) : 0;
        int seconds = LocalTime.of(hh, mm, ss).toSecondOfDay() + days * ONE_DAY_SECONDS;
        return negative ? -seconds : seconds;
    }

    public static int time(String hhmmss, int defaultValue) {
        if (hhmmss == null || hhmmss.isBlank()) {
            return defaultValue;
        }
        return TimeUtils.time(hhmmss.trim());
    }

    public static int[] times(@Nonnull String input) {
        return Arrays.stream(input.split("[ ,;]+")).mapToInt(TimeUtils::time).toArray();
    }

    public static String timeToStrCompact(int time) {
        return RelativeTime.ofSeconds(time).toCompactStr();
    }

    public static String durationToStrCompact(Duration duration) {
        return TimeUtils.timeToStrCompact((int)duration.toSeconds());
    }

    public static String timeToStrCompact(int time, int notSetValue) {
        return time == notSetValue ? "" : RelativeTime.ofSeconds(time).toCompactStr();
    }

    public static String timeToStrCompact(ZonedDateTime time) {
        return time == null ? "" : RelativeTime.from(time).toCompactStr();
    }

    public static String timeToStrLong(int time) {
        return RelativeTime.ofSeconds(time).toLongStr();
    }

    public static String timeToStrLong(int time, int notSetValue) {
        return time == notSetValue ? "" : RelativeTime.ofSeconds(time).toLongStr();
    }

    public static String timeToStrLong(ZonedDateTime time) {
        return RelativeTime.from(time).toLongStr();
    }

    public static String timeToStrLong(LocalTime time) {
        return time.toString();
    }

    public static ZonedDateTime zonedDateTime(LocalDate date, int seconds, ZoneId zoneId) {
        return RelativeTime.ofSeconds(seconds).toZonedDateTime(date, zoneId);
    }
}

