/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.util.resources;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceBundleAdaptor {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceBundleAdaptor.class);
    private final String bundle;

    public ResourceBundleAdaptor(Class<?> c) {
        this.bundle = c.getSimpleName();
    }

    public synchronized String get(String name, Locale l) throws Exception {
        ResourceBundle rb = ResourceBundleAdaptor.getBundle(this.bundle, l);
        return rb.getString(name);
    }

    private static ResourceBundle getBundle(String name, Locale l) {
        try {
            return ResourceBundle.getBundle(name, l);
        }
        catch (MissingResourceException e) {
            LOG.error("Uh oh...no .properties file could be found, so things are most definitely not going to turn out well!!!", (Throwable)e);
            throw e;
        }
    }
}

