/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.updater.vehicle_rental.datasources;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.entur.gbfs.v2_2.gbfs.GBFS;
import org.entur.gbfs.v2_2.gbfs.GBFSFeed;
import org.entur.gbfs.v2_2.gbfs.GBFSFeedName;
import org.entur.gbfs.v2_2.gbfs.GBFSFeeds;
import org.opentripplanner.updater.UpdaterConstructionException;
import org.opentripplanner.util.HttpUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GbfsFeedLoader {
    private static final Logger LOG = LoggerFactory.getLogger(GbfsFeedLoader.class);
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private final Map<GBFSFeedName, GBFSFeedUpdater<?>> feedUpdaters = new HashMap();
    private final Map<String, String> httpHeaders;

    public GbfsFeedLoader(String url, Map<String, String> httpHeaders, String languageCode) {
        GBFSFeeds feeds;
        GBFS data;
        URI uri;
        this.httpHeaders = httpHeaders;
        try {
            uri = new URI(url);
        }
        catch (URISyntaxException e) {
            throw new UpdaterConstructionException("Invalid url " + url);
        }
        if (!url.endsWith("gbfs.json")) {
            LOG.warn("GBFS autoconfiguration url {} does not end with gbfs.json. Make sure it follows the specification, if you get any errors using it.", (Object)url);
        }
        if ((data = GbfsFeedLoader.fetchFeed(uri, httpHeaders, GBFS.class)) == null) {
            throw new UpdaterConstructionException("Could not fetch the feed auto-configuration file from " + uri);
        }
        GBFSFeeds gBFSFeeds = feeds = languageCode == null ? (GBFSFeeds)data.getFeedsData().values().iterator().next() : (GBFSFeeds)data.getFeedsData().get(languageCode);
        if (feeds == null) {
            throw new UpdaterConstructionException("Language " + languageCode + " does not exist in feed " + uri);
        }
        for (GBFSFeed feed : feeds.getFeeds()) {
            GBFSFeedName feedName = feed.getName();
            if (this.feedUpdaters.containsKey(feedName)) {
                throw new UpdaterConstructionException("Feed contains duplicate url for feed " + feedName + ". Urls: " + feed.getUrl() + ", " + this.feedUpdaters.get((Object)feedName).url);
            }
            if (feed.getName() == null) continue;
            this.feedUpdaters.put(feedName, new GBFSFeedUpdater(feed));
        }
    }

    public boolean update() {
        boolean didUpdate = false;
        for (GBFSFeedUpdater<?> updater : this.feedUpdaters.values()) {
            if (!updater.shouldUpdate()) continue;
            boolean success = updater.fetchData();
            if (!success) {
                return false;
            }
            didUpdate = true;
        }
        return didUpdate;
    }

    public <T> T getFeed(Class<T> feed) {
        GBFSFeedUpdater<?> updater = this.feedUpdaters.get(GBFSFeedName.fromClass(feed));
        if (updater == null) {
            return null;
        }
        return feed.cast(updater.getData());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static <T> T fetchFeed(URI uri, Map<String, String> httpHeaders, Class<T> clazz) {
        try (InputStream is = HttpUtils.openInputStream(uri, httpHeaders);){
            if (is == null) {
                LOG.warn("Failed to get data from url {}", (Object)uri);
                T t = null;
                return t;
            }
            Object object = objectMapper.readValue(is, clazz);
            return (T)object;
        }
        catch (IOException | IllegalArgumentException e) {
            LOG.warn("Error parsing vehicle rental feed from {}. Details: {}.", new Object[]{uri, e.getMessage(), e});
            return null;
        }
    }

    static {
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
    }

    private class GBFSFeedUpdater<T> {
        private final URI url;
        private final Class<T> implementingClass;
        private int nextUpdate;
        private T data;

        private GBFSFeedUpdater(GBFSFeed feed) {
            this.url = feed.getUrl();
            this.implementingClass = feed.getName().implementingClass();
        }

        private T getData() {
            return this.data;
        }

        private boolean fetchData() {
            T newData = GbfsFeedLoader.fetchFeed(this.url, GbfsFeedLoader.this.httpHeaders, this.implementingClass);
            if (newData == null) {
                LOG.error("Invalid data for {}", (Object)this.url);
                this.nextUpdate = this.getCurrentTimeSeconds();
                return false;
            }
            this.data = newData;
            try {
                Integer lastUpdated = (Integer)this.implementingClass.getMethod("getLastUpdated", new Class[0]).invoke(newData, new Object[0]);
                Integer ttl = (Integer)this.implementingClass.getMethod("getTtl", new Class[0]).invoke(newData, new Object[0]);
                this.nextUpdate = lastUpdated == null || ttl == null ? this.getCurrentTimeSeconds() : lastUpdated + ttl;
            }
            catch (ClassCastException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                LOG.error("Invalid lastUpdated or ttl for {}", (Object)this.url);
                this.nextUpdate = this.getCurrentTimeSeconds();
            }
            return true;
        }

        private boolean shouldUpdate() {
            return this.getCurrentTimeSeconds() >= this.nextUpdate;
        }

        private int getCurrentTimeSeconds() {
            return (int)(System.currentTimeMillis() / 1000L);
        }
    }
}

