/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.updater.vehicle_rental;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.opentripplanner.graph_builder.linking.DisposableEdgeCollection;
import org.opentripplanner.graph_builder.linking.LinkingDirection;
import org.opentripplanner.graph_builder.linking.VertexLinker;
import org.opentripplanner.routing.core.TraverseMode;
import org.opentripplanner.routing.core.TraverseModeSet;
import org.opentripplanner.routing.edgetype.StreetVehicleRentalLink;
import org.opentripplanner.routing.edgetype.VehicleRentalEdge;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.routing.vehicle_rental.RentalVehicleType;
import org.opentripplanner.routing.vehicle_rental.VehicleRentalPlace;
import org.opentripplanner.routing.vehicle_rental.VehicleRentalStationService;
import org.opentripplanner.routing.vertextype.StreetVertex;
import org.opentripplanner.routing.vertextype.VehicleRentalPlaceVertex;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.service.TransitModel;
import org.opentripplanner.updater.DataSource;
import org.opentripplanner.updater.GraphWriterRunnable;
import org.opentripplanner.updater.PollingGraphUpdater;
import org.opentripplanner.updater.UpdaterConstructionException;
import org.opentripplanner.updater.WriteToGraphCallback;
import org.opentripplanner.updater.vehicle_rental.VehicleRentalUpdaterParameters;
import org.opentripplanner.util.lang.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VehicleRentalUpdater
extends PollingGraphUpdater {
    private static final Logger LOG = LoggerFactory.getLogger(VehicleRentalUpdater.class);
    private final DataSource<VehicleRentalPlace> source;
    private WriteToGraphCallback saveResultOnGraph;
    Map<FeedScopedId, VehicleRentalPlaceVertex> verticesByStation = new HashMap<FeedScopedId, VehicleRentalPlaceVertex>();
    Map<FeedScopedId, DisposableEdgeCollection> tempEdgesByStation = new HashMap<FeedScopedId, DisposableEdgeCollection>();
    private VertexLinker linker;
    private VehicleRentalStationService service;

    public VehicleRentalUpdater(VehicleRentalUpdaterParameters parameters, DataSource<VehicleRentalPlace> source, VertexLinker vertexLinker, VehicleRentalStationService vehicleRentalStationService) throws IllegalArgumentException {
        super(parameters);
        LOG.info("Setting up vehicle rental updater.");
        this.source = source;
        this.linker = vertexLinker;
        this.service = vehicleRentalStationService;
        try {
            source.setup();
        }
        catch (UpdaterConstructionException e) {
            LOG.warn("Unable to setup updater: {}", (Object)parameters.getConfigRef(), (Object)e);
        }
        if (this.pollingPeriodSeconds() <= 0) {
            LOG.info("Creating vehicle-rental updater running once only (non-polling): {}", source);
        } else {
            LOG.info("Creating vehicle-rental updater running every {} seconds: {}", (Object)this.pollingPeriodSeconds(), source);
        }
    }

    @Override
    public void setGraphUpdaterManager(WriteToGraphCallback saveResultOnGraph) {
        this.saveResultOnGraph = saveResultOnGraph;
    }

    public String toString() {
        return ToStringBuilder.of(VehicleRentalUpdater.class).addObj("source", this.source).toString();
    }

    @Override
    public String getConfigRef() {
        return this.toString();
    }

    @Override
    protected void runPolling() {
        LOG.debug("Updating vehicle rental stations from {}", this.source);
        if (!this.source.update()) {
            LOG.debug("No updates");
            return;
        }
        List<VehicleRentalPlace> stations = this.source.getUpdates();
        VehicleRentalGraphWriterRunnable graphWriterRunnable = new VehicleRentalGraphWriterRunnable(stations);
        this.saveResultOnGraph.execute(graphWriterRunnable);
    }

    private class VehicleRentalGraphWriterRunnable
    implements GraphWriterRunnable {
        private final List<VehicleRentalPlace> stations;

        public VehicleRentalGraphWriterRunnable(List<VehicleRentalPlace> stations) {
            this.stations = stations;
        }

        @Override
        public void run(Graph graph, TransitModel transitModel) {
            HashSet<FeedScopedId> stationSet = new HashSet<FeedScopedId>();
            for (VehicleRentalPlace station : this.stations) {
                VehicleRentalUpdater.this.service.addVehicleRentalStation(station);
                stationSet.add(station.getId());
                VehicleRentalPlaceVertex vehicleRentalVertex = VehicleRentalUpdater.this.verticesByStation.get(station.getId());
                if (vehicleRentalVertex == null) {
                    vehicleRentalVertex = new VehicleRentalPlaceVertex(graph, station);
                    DisposableEdgeCollection tempEdges = VehicleRentalUpdater.this.linker.linkVertexForRealTime(vehicleRentalVertex, new TraverseModeSet(TraverseMode.WALK), LinkingDirection.BOTH_WAYS, (vertex, streetVertex) -> List.of(new StreetVehicleRentalLink((VehicleRentalPlaceVertex)vertex, (StreetVertex)streetVertex), new StreetVehicleRentalLink((StreetVertex)streetVertex, (VehicleRentalPlaceVertex)vertex)));
                    if (vehicleRentalVertex.getOutgoing().isEmpty()) {
                        LOG.info("VehicleRentalPlace {} is unlinked", (Object)vehicleRentalVertex);
                    }
                    Set formFactors = Stream.concat(station.getAvailablePickupFormFactors(false).stream(), station.getAvailableDropoffFormFactors(false).stream()).collect(Collectors.toSet());
                    for (RentalVehicleType.FormFactor formFactor : formFactors) {
                        tempEdges.addEdge(new VehicleRentalEdge(vehicleRentalVertex, formFactor));
                    }
                    VehicleRentalUpdater.this.verticesByStation.put(station.getId(), vehicleRentalVertex);
                    VehicleRentalUpdater.this.tempEdgesByStation.put(station.getId(), tempEdges);
                    continue;
                }
                vehicleRentalVertex.setStation(station);
            }
            ArrayList<FeedScopedId> toRemove = new ArrayList<FeedScopedId>();
            for (Map.Entry<FeedScopedId, VehicleRentalPlaceVertex> entry : VehicleRentalUpdater.this.verticesByStation.entrySet()) {
                FeedScopedId station = entry.getKey();
                if (stationSet.contains(station)) continue;
                toRemove.add(station);
                VehicleRentalUpdater.this.service.removeVehicleRentalStation(station);
            }
            for (FeedScopedId station : toRemove) {
                VehicleRentalUpdater.this.verticesByStation.remove(station);
                VehicleRentalUpdater.this.tempEdgesByStation.get(station).disposeEdges();
                VehicleRentalUpdater.this.tempEdgesByStation.remove(station);
            }
        }
    }
}

