/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.updater.trip;

import com.google.transit.realtime.GtfsRealtime;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.opentripplanner.updater.trip.TripUpdateSource;
import org.opentripplanner.util.HttpUtils;
import org.opentripplanner.util.lang.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GtfsRealtimeHttpTripUpdateSource
implements TripUpdateSource {
    private static final Logger LOG = LoggerFactory.getLogger(GtfsRealtimeHttpTripUpdateSource.class);
    private final String feedId;
    private final String url;
    private boolean fullDataset = true;

    public GtfsRealtimeHttpTripUpdateSource(Parameters config) {
        this.feedId = config.getFeedId();
        this.url = config.getUrl();
    }

    @Override
    public List<GtfsRealtime.TripUpdate> getUpdates() {
        ArrayList<GtfsRealtime.TripUpdate> updates = null;
        this.fullDataset = true;
        try {
            InputStream is = HttpUtils.getData(URI.create(this.url), Map.of("Accept", "application/x-google-protobuf, application/x-protobuf, application/protobuf, application/octet-stream, */*"));
            if (is != null) {
                GtfsRealtime.FeedMessage feedMessage = GtfsRealtime.FeedMessage.parseFrom(is);
                List<GtfsRealtime.FeedEntity> feedEntityList = feedMessage.getEntityList();
                if (feedMessage.hasHeader() && feedMessage.getHeader().hasIncrementality() && feedMessage.getHeader().getIncrementality().equals((Object)GtfsRealtime.FeedHeader.Incrementality.DIFFERENTIAL)) {
                    this.fullDataset = false;
                }
                updates = new ArrayList<GtfsRealtime.TripUpdate>(feedEntityList.size());
                for (GtfsRealtime.FeedEntity feedEntity : feedEntityList) {
                    if (!feedEntity.hasTripUpdate()) continue;
                    updates.add(feedEntity.getTripUpdate());
                }
            } else {
                LOG.error("GTFS-RT feed at {} did not return usable data", (Object)this.url);
            }
        }
        catch (Exception e) {
            LOG.error("Failed to parse GTFS-RT feed from {}", (Object)this.url, (Object)e);
        }
        return updates;
    }

    @Override
    public boolean getFullDatasetValueOfLastUpdates() {
        return this.fullDataset;
    }

    @Override
    public String getFeedId() {
        return this.feedId;
    }

    public String toString() {
        return ToStringBuilder.of(this.getClass()).addStr("feedId", this.feedId).addStr("url", this.url).toString();
    }

    static interface Parameters {
        public String getFeedId();

        public String getUrl();
    }
}

