/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.updater.configure;

import java.util.ArrayList;
import java.util.List;
import org.opentripplanner.ext.siri.SiriTimetableSnapshotSource;
import org.opentripplanner.ext.siri.updater.SiriETGooglePubsubUpdater;
import org.opentripplanner.ext.siri.updater.SiriETGooglePubsubUpdaterParameters;
import org.opentripplanner.ext.siri.updater.SiriETUpdater;
import org.opentripplanner.ext.siri.updater.SiriETUpdaterParameters;
import org.opentripplanner.ext.siri.updater.SiriSXUpdater;
import org.opentripplanner.ext.siri.updater.SiriSXUpdaterParameters;
import org.opentripplanner.ext.siri.updater.SiriVMUpdater;
import org.opentripplanner.ext.siri.updater.SiriVMUpdaterParameters;
import org.opentripplanner.ext.siri.updater.azure.SiriAzureETUpdater;
import org.opentripplanner.ext.siri.updater.azure.SiriAzureETUpdaterParameters;
import org.opentripplanner.ext.siri.updater.azure.SiriAzureSXUpdater;
import org.opentripplanner.ext.siri.updater.azure.SiriAzureSXUpdaterParameters;
import org.opentripplanner.ext.vehiclerentalservicedirectory.VehicleRentalServiceDirectoryFetcher;
import org.opentripplanner.ext.vehiclerentalservicedirectory.api.VehicleRentalServiceDirectoryFetcherParameters;
import org.opentripplanner.model.calendar.openinghours.OpeningHoursCalendarService;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.transit.service.TransitModel;
import org.opentripplanner.updater.DataSource;
import org.opentripplanner.updater.GraphUpdater;
import org.opentripplanner.updater.GraphUpdaterManager;
import org.opentripplanner.updater.UpdatersParameters;
import org.opentripplanner.updater.alert.GtfsRealtimeAlertsUpdater;
import org.opentripplanner.updater.alert.GtfsRealtimeAlertsUpdaterParameters;
import org.opentripplanner.updater.street_note.WFSNotePollingGraphUpdaterParameters;
import org.opentripplanner.updater.street_note.WinkkiPollingGraphUpdater;
import org.opentripplanner.updater.trip.MqttGtfsRealtimeUpdater;
import org.opentripplanner.updater.trip.MqttGtfsRealtimeUpdaterParameters;
import org.opentripplanner.updater.trip.PollingTripUpdater;
import org.opentripplanner.updater.trip.PollingTripUpdaterParameters;
import org.opentripplanner.updater.trip.TimetableSnapshotSource;
import org.opentripplanner.updater.trip.WebsocketGtfsRealtimeUpdater;
import org.opentripplanner.updater.trip.WebsocketGtfsRealtimeUpdaterParameters;
import org.opentripplanner.updater.vehicle_parking.VehicleParkingDataSourceFactory;
import org.opentripplanner.updater.vehicle_parking.VehicleParkingUpdater;
import org.opentripplanner.updater.vehicle_parking.VehicleParkingUpdaterParameters;
import org.opentripplanner.updater.vehicle_position.PollingVehiclePositionUpdater;
import org.opentripplanner.updater.vehicle_position.VehiclePositionsUpdaterParameters;
import org.opentripplanner.updater.vehicle_rental.VehicleRentalUpdater;
import org.opentripplanner.updater.vehicle_rental.VehicleRentalUpdaterParameters;
import org.opentripplanner.updater.vehicle_rental.datasources.VehicleRentalDataSourceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdaterConfigurator {
    private static final Logger LOG = LoggerFactory.getLogger(UpdaterConfigurator.class);
    private final Graph graph;
    private final TransitModel transitModel;
    private final UpdatersParameters updatersParameters;
    private SiriTimetableSnapshotSource siriTimetableSnapshotSource = null;
    private TimetableSnapshotSource gtfsTimetableSnapshotSource = null;

    private UpdaterConfigurator(Graph graph, TransitModel transitModel, UpdatersParameters updatersParameters) {
        this.graph = graph;
        this.transitModel = transitModel;
        this.updatersParameters = updatersParameters;
    }

    public static void configure(Graph graph, TransitModel transitModel, UpdatersParameters updatersParameters) {
        new UpdaterConfigurator(graph, transitModel, updatersParameters).configure();
    }

    private void configure() {
        ArrayList<GraphUpdater> updaters = new ArrayList<GraphUpdater>();
        updaters.addAll(this.createUpdatersFromConfig());
        updaters.addAll(this.fetchVehicleRentalServicesFromOnlineDirectory(this.updatersParameters.getVehicleRentalServiceDirectoryFetcherParameters()));
        GraphUpdaterManager updaterManager = new GraphUpdaterManager(this.graph, this.transitModel, updaters);
        updaterManager.startUpdaters();
        if (updaterManager.numberOfUpdaters() == 0) {
            updaterManager.stop();
        } else {
            this.transitModel.setUpdaterManager(updaterManager);
        }
    }

    public static void shutdownGraph(TransitModel transitModel) {
        GraphUpdaterManager updaterManager = transitModel.getUpdaterManager();
        if (updaterManager != null) {
            LOG.info("Stopping updater manager with {} updaters.", (Object)updaterManager.numberOfUpdaters());
            updaterManager.stop();
        }
    }

    private List<GraphUpdater> fetchVehicleRentalServicesFromOnlineDirectory(VehicleRentalServiceDirectoryFetcherParameters parameters) {
        if (parameters == null) {
            return List.of();
        }
        return VehicleRentalServiceDirectoryFetcher.createUpdatersFromEndpoint(parameters, this.graph.getLinker(), this.graph.getVehicleRentalStationService());
    }

    private List<GraphUpdater> createUpdatersFromConfig() {
        DataSource<Object> source;
        OpeningHoursCalendarService openingHoursCalendarService = this.graph.getOpeningHoursCalendarService();
        ArrayList<GraphUpdater> updaters = new ArrayList<GraphUpdater>();
        for (VehicleRentalUpdaterParameters vehicleRentalUpdaterParameters : this.updatersParameters.getVehicleRentalParameters()) {
            source = VehicleRentalDataSourceFactory.create(vehicleRentalUpdaterParameters.sourceParameters());
            updaters.add(new VehicleRentalUpdater(vehicleRentalUpdaterParameters, source, this.graph.getLinker(), this.graph.getVehicleRentalStationService()));
        }
        for (GtfsRealtimeAlertsUpdaterParameters gtfsRealtimeAlertsUpdaterParameters : this.updatersParameters.getGtfsRealtimeAlertsUpdaterParameters()) {
            updaters.add(new GtfsRealtimeAlertsUpdater(gtfsRealtimeAlertsUpdaterParameters, this.transitModel));
        }
        for (PollingTripUpdaterParameters pollingTripUpdaterParameters : this.updatersParameters.getPollingStoptimeUpdaterParameters()) {
            updaters.add(new PollingTripUpdater(pollingTripUpdaterParameters, this.transitModel, this.provideGtfsTimetableSnapshot()));
        }
        for (VehiclePositionsUpdaterParameters vehiclePositionsUpdaterParameters : this.updatersParameters.getVehiclePositionsUpdaterParameters()) {
            updaters.add(new PollingVehiclePositionUpdater(vehiclePositionsUpdaterParameters, this.graph.getVehiclePositionService(), this.transitModel));
        }
        for (SiriETUpdaterParameters siriETUpdaterParameters : this.updatersParameters.getSiriETUpdaterParameters()) {
            updaters.add(new SiriETUpdater(siriETUpdaterParameters, this.transitModel, this.provideSiriTimetableSnapshot()));
        }
        for (SiriETGooglePubsubUpdaterParameters siriETGooglePubsubUpdaterParameters : this.updatersParameters.getSiriETGooglePubsubUpdaterParameters()) {
            updaters.add(new SiriETGooglePubsubUpdater(siriETGooglePubsubUpdaterParameters, this.transitModel, this.provideSiriTimetableSnapshot()));
        }
        for (SiriSXUpdaterParameters siriSXUpdaterParameters : this.updatersParameters.getSiriSXUpdaterParameters()) {
            updaters.add(new SiriSXUpdater(siriSXUpdaterParameters, this.transitModel));
        }
        for (SiriVMUpdaterParameters siriVMUpdaterParameters : this.updatersParameters.getSiriVMUpdaterParameters()) {
            updaters.add(new SiriVMUpdater(this.provideSiriTimetableSnapshot(), siriVMUpdaterParameters, this.transitModel));
        }
        for (WebsocketGtfsRealtimeUpdaterParameters websocketGtfsRealtimeUpdaterParameters : this.updatersParameters.getWebsocketGtfsRealtimeUpdaterParameters()) {
            updaters.add(new WebsocketGtfsRealtimeUpdater(websocketGtfsRealtimeUpdaterParameters, this.provideGtfsTimetableSnapshot(), this.transitModel));
        }
        for (MqttGtfsRealtimeUpdaterParameters mqttGtfsRealtimeUpdaterParameters : this.updatersParameters.getMqttGtfsRealtimeUpdaterParameters()) {
            updaters.add(new MqttGtfsRealtimeUpdater(mqttGtfsRealtimeUpdaterParameters, this.transitModel, this.provideGtfsTimetableSnapshot()));
        }
        for (VehicleParkingUpdaterParameters vehicleParkingUpdaterParameters : this.updatersParameters.getVehicleParkingUpdaterParameters()) {
            source = VehicleParkingDataSourceFactory.create(vehicleParkingUpdaterParameters, openingHoursCalendarService);
            updaters.add(new VehicleParkingUpdater(vehicleParkingUpdaterParameters, source, this.graph.getLinker(), this.graph.getVehicleParkingService()));
        }
        for (WFSNotePollingGraphUpdaterParameters wFSNotePollingGraphUpdaterParameters : this.updatersParameters.getWinkkiPollingGraphUpdaterParameters()) {
            updaters.add(new WinkkiPollingGraphUpdater(wFSNotePollingGraphUpdaterParameters, this.graph));
        }
        for (SiriAzureETUpdaterParameters siriAzureETUpdaterParameters : this.updatersParameters.getSiriAzureETUpdaterParameters()) {
            updaters.add(new SiriAzureETUpdater(siriAzureETUpdaterParameters, this.transitModel, this.provideSiriTimetableSnapshot()));
        }
        for (SiriAzureSXUpdaterParameters siriAzureSXUpdaterParameters : this.updatersParameters.getSiriAzureSXUpdaterParameters()) {
            updaters.add(new SiriAzureSXUpdater(siriAzureSXUpdaterParameters, this.transitModel));
        }
        return updaters;
    }

    private SiriTimetableSnapshotSource provideSiriTimetableSnapshot() {
        if (this.siriTimetableSnapshotSource == null) {
            this.siriTimetableSnapshotSource = new SiriTimetableSnapshotSource(this.updatersParameters.timetableSnapshotParameters(), this.transitModel);
        }
        return this.siriTimetableSnapshotSource;
    }

    private TimetableSnapshotSource provideGtfsTimetableSnapshot() {
        if (this.gtfsTimetableSnapshotSource == null) {
            this.gtfsTimetableSnapshotSource = new TimetableSnapshotSource(this.updatersParameters.timetableSnapshotParameters(), this.transitModel);
        }
        return this.gtfsTimetableSnapshotSource;
    }
}

