/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.updater.alert;

import com.google.transit.realtime.GtfsRealtime;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import org.opentripplanner.routing.impl.TransitAlertServiceImpl;
import org.opentripplanner.routing.services.TransitAlertService;
import org.opentripplanner.transit.service.DefaultTransitService;
import org.opentripplanner.transit.service.TransitModel;
import org.opentripplanner.updater.GtfsRealtimeFuzzyTripMatcher;
import org.opentripplanner.updater.PollingGraphUpdater;
import org.opentripplanner.updater.WriteToGraphCallback;
import org.opentripplanner.updater.alert.AlertsUpdateHandler;
import org.opentripplanner.updater.alert.GtfsRealtimeAlertsUpdaterParameters;
import org.opentripplanner.updater.alert.TransitAlertProvider;
import org.opentripplanner.util.HttpUtils;
import org.opentripplanner.util.lang.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GtfsRealtimeAlertsUpdater
extends PollingGraphUpdater
implements TransitAlertProvider {
    private static final Logger LOG = LoggerFactory.getLogger(GtfsRealtimeAlertsUpdater.class);
    private final String url;
    private final AlertsUpdateHandler updateHandler;
    private final TransitAlertService transitAlertService;
    private WriteToGraphCallback saveResultOnGraph;
    private Long lastTimestamp = Long.MIN_VALUE;

    public GtfsRealtimeAlertsUpdater(GtfsRealtimeAlertsUpdaterParameters config, TransitModel transitModel) {
        super(config);
        this.url = config.getUrl();
        TransitAlertServiceImpl transitAlertService = new TransitAlertServiceImpl(transitModel);
        GtfsRealtimeFuzzyTripMatcher fuzzyTripMatcher = config.fuzzyTripMatching() ? new GtfsRealtimeFuzzyTripMatcher(new DefaultTransitService(transitModel)) : null;
        this.transitAlertService = transitAlertService;
        this.updateHandler = new AlertsUpdateHandler();
        this.updateHandler.setEarlyStart(config.getEarlyStartSec());
        this.updateHandler.setFeedId(config.getFeedId());
        this.updateHandler.setTransitAlertService(transitAlertService);
        this.updateHandler.setFuzzyTripMatcher(fuzzyTripMatcher);
        LOG.info("Creating real-time alert updater running every {} seconds : {}", (Object)this.pollingPeriodSeconds(), (Object)this.url);
    }

    @Override
    public void setGraphUpdaterManager(WriteToGraphCallback saveResultOnGraph) {
        this.saveResultOnGraph = saveResultOnGraph;
    }

    @Override
    public TransitAlertService getTransitAlertService() {
        return this.transitAlertService;
    }

    public String toString() {
        return ToStringBuilder.of(this.getClass()).addStr("url", this.url).toString();
    }

    @Override
    protected void runPolling() {
        try {
            InputStream data = HttpUtils.getData(URI.create(this.url), Map.of("Accept", "application/x-google-protobuf, application/x-protobuf, application/protobuf, application/octet-stream, */*"));
            if (data == null) {
                throw new RuntimeException("Failed to get data from url " + this.url);
            }
            GtfsRealtime.FeedMessage feed = (GtfsRealtime.FeedMessage)GtfsRealtime.FeedMessage.PARSER.parseFrom(data);
            long feedTimestamp = feed.getHeader().getTimestamp();
            if (feedTimestamp == this.lastTimestamp) {
                LOG.debug("Ignoring feed with a timestamp that has not been updated from {}", (Object)this.url);
                return;
            }
            if (feedTimestamp < this.lastTimestamp) {
                LOG.info("Ignoring feed with older than previous timestamp from {}", (Object)this.url);
                return;
            }
            this.saveResultOnGraph.execute((graph, transitModel) -> this.updateHandler.update(feed));
            this.lastTimestamp = feedTimestamp;
        }
        catch (Exception e) {
            LOG.error("Error reading gtfs-realtime feed from " + this.url, (Throwable)e);
        }
    }
}

