/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.updater;

import java.util.List;
import java.util.Map;
import org.opentripplanner.updater.DataSource;
import org.opentripplanner.util.xml.XmlDataListDownloader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GenericXmlDataSource<T>
implements DataSource<T> {
    private static final Logger LOG = LoggerFactory.getLogger(GenericXmlDataSource.class);
    private String url;
    protected List<T> updates = List.of();
    private final XmlDataListDownloader<T> xmlDownloader;

    public GenericXmlDataSource(String url, String xpath) {
        this.url = url;
        this.xmlDownloader = new XmlDataListDownloader();
        this.xmlDownloader.setPath(xpath);
        this.xmlDownloader.setDataFactory(attributes -> this.parseElement(attributes));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean update() {
        List<T> updates = this.xmlDownloader.download(this.url, false);
        if (updates != null) {
            GenericXmlDataSource genericXmlDataSource = this;
            synchronized (genericXmlDataSource) {
                this.updates = updates;
            }
            return true;
        }
        LOG.info("Can't update entities from: {}, keeping current list.", (Object)this.url);
        return false;
    }

    @Override
    public List<T> getUpdates() {
        return this.updates;
    }

    protected abstract T parseElement(Map<String, String> var1);
}

