/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.service;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import gnu.trove.set.hash.TIntHashSet;
import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.opentripplanner.ext.flex.trip.FlexTrip;
import org.opentripplanner.graph_builder.DataImportIssueStore;
import org.opentripplanner.graph_builder.issues.NoFutureDates;
import org.opentripplanner.model.FeedInfo;
import org.opentripplanner.model.PathTransfer;
import org.opentripplanner.model.TimetableSnapshot;
import org.opentripplanner.model.TimetableSnapshotProvider;
import org.opentripplanner.model.calendar.CalendarService;
import org.opentripplanner.model.calendar.CalendarServiceData;
import org.opentripplanner.model.calendar.impl.CalendarServiceImpl;
import org.opentripplanner.model.transfer.DefaultTransferService;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.TransitLayer;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.mappers.TransitLayerUpdater;
import org.opentripplanner.routing.impl.DelegatingTransitAlertServiceImpl;
import org.opentripplanner.routing.services.TransitAlertService;
import org.opentripplanner.routing.util.ConcurrentPublished;
import org.opentripplanner.transit.model.basic.Notice;
import org.opentripplanner.transit.model.basic.TransitMode;
import org.opentripplanner.transit.model.framework.AbstractTransitEntity;
import org.opentripplanner.transit.model.framework.Deduplicator;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.network.TripPattern;
import org.opentripplanner.transit.model.organization.Agency;
import org.opentripplanner.transit.model.organization.Operator;
import org.opentripplanner.transit.model.site.StopLocation;
import org.opentripplanner.transit.model.timetable.TripOnServiceDate;
import org.opentripplanner.transit.service.StopModel;
import org.opentripplanner.transit.service.TransitModelIndex;
import org.opentripplanner.updater.GraphUpdaterManager;
import org.opentripplanner.util.lang.ObjectUtils;
import org.opentripplanner.util.time.ServiceDateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransitModel
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(TransitModel.class);
    private final Collection<Agency> agencies = new ArrayList<Agency>();
    private final Collection<Operator> operators = new ArrayList<Operator>();
    private final Collection<String> feedIds = new HashSet<String>();
    private final Map<String, FeedInfo> feedInfoForId = new HashMap<String, FeedInfo>();
    private final Multimap<AbstractTransitEntity, Notice> noticesByElement = HashMultimap.create();
    private final DefaultTransferService transferService = new DefaultTransferService();
    private final HashSet<TransitMode> transitModes = new HashSet();
    private final Map<FeedScopedId, Integer> serviceCodes = new HashMap<FeedScopedId, Integer>();
    private final Multimap<StopLocation, PathTransfer> transfersByStop = HashMultimap.create();
    private StopModel stopModel;
    private ZonedDateTime transitServiceStarts = LocalDate.MAX.atStartOfDay(ZoneId.systemDefault());
    private ZonedDateTime transitServiceEnds = LocalDate.MIN.atStartOfDay(ZoneId.systemDefault());
    private final transient ConcurrentPublished<TransitLayer> realtimeTransitLayer = new ConcurrentPublished();
    private final transient Deduplicator deduplicator;
    private final CalendarServiceData calendarServiceData = new CalendarServiceData();
    private transient TransitModelIndex index;
    private transient TimetableSnapshotProvider timetableSnapshotProvider = null;
    private ZoneId timeZone = null;
    private boolean timeZoneExplicitlySet = false;
    private transient GraphUpdaterManager updaterManager = null;
    private boolean hasTransit = false;
    private boolean hasFrequencyService = false;
    private boolean hasScheduledService = false;
    private final Map<FeedScopedId, TripPattern> tripPatternForId = new HashMap<FeedScopedId, TripPattern>();
    private final Map<FeedScopedId, TripOnServiceDate> tripOnServiceDates = new HashMap<FeedScopedId, TripOnServiceDate>();
    private final Map<FeedScopedId, FlexTrip<?, ?>> flexTripsById = new HashMap();
    private transient TransitLayer transitLayer;
    private transient TransitLayerUpdater transitLayerUpdater;
    private transient TransitAlertService transitAlertService;

    @Inject
    public TransitModel(StopModel stopModel, Deduplicator deduplicator) {
        this.stopModel = Objects.requireNonNull(stopModel);
        this.deduplicator = deduplicator;
    }

    public TransitModel() {
        this(new StopModel(), new Deduplicator());
    }

    public void index() {
        if (this.index == null) {
            LOG.info("Index transit model...");
            this.index = new TransitModelIndex(this);
            LOG.info("Index transit model complete.");
        }
    }

    public TimetableSnapshot getTimetableSnapshot() {
        return this.timetableSnapshotProvider == null ? null : this.timetableSnapshotProvider.getTimetableSnapshot();
    }

    public void initTimetableSnapshotProvider(TimetableSnapshotProvider timetableSnapshotProvider) {
        if (this.timetableSnapshotProvider != null) {
            throw new IllegalArgumentException("We support only one timetableSnapshotSource, there are two implementation; one for GTFS and one for Netex/Siri. They need to be refactored to work together. This cast will fail if updaters try setup both.");
        }
        this.timetableSnapshotProvider = timetableSnapshotProvider;
    }

    public TransitLayer getTransitLayer() {
        return this.transitLayer;
    }

    public void setTransitLayer(TransitLayer transitLayer) {
        this.transitLayer = transitLayer;
    }

    public TransitLayer getRealtimeTransitLayer() {
        return this.realtimeTransitLayer.get();
    }

    public void setRealtimeTransitLayer(TransitLayer realtimeTransitLayer) {
        this.realtimeTransitLayer.publish(realtimeTransitLayer);
    }

    public boolean hasRealtimeTransitLayer() {
        return this.realtimeTransitLayer != null;
    }

    public DefaultTransferService getTransferService() {
        return this.transferService;
    }

    public boolean transitFeedCovers(Instant time) {
        return !time.isBefore(this.transitServiceStarts.toInstant()) && time.isBefore(this.transitServiceEnds.toInstant());
    }

    public void addTransitMode(TransitMode mode) {
        this.invalidateIndex();
        this.transitModes.add(mode);
    }

    public HashSet<TransitMode> getTransitModes() {
        return this.transitModes;
    }

    public CalendarService getCalendarService() {
        return new CalendarServiceImpl(this.calendarServiceData);
    }

    public void updateCalendarServiceData(boolean hasActiveTransit, CalendarServiceData data, DataImportIssueStore issueStore) {
        this.invalidateIndex();
        this.updateTransitFeedValidity(data, issueStore);
        this.calendarServiceData.add(data);
        this.updateHasTransit(hasActiveTransit);
    }

    @Nullable
    public FeedScopedId getOrCreateServiceIdForDate(LocalDate serviceDate) {
        ZonedDateTime time = ServiceDateUtils.asStartOfService(serviceDate, this.getTimeZone());
        if (!this.transitFeedCovers(time.toInstant())) {
            return null;
        }
        FeedScopedId serviceId = ((CalendarServiceImpl)this.getCalendarService()).getOrCreateServiceIdForDate(serviceDate);
        if (!this.serviceCodes.containsKey(serviceId)) {
            int serviceCode = this.serviceCodes.size();
            this.serviceCodes.put(serviceId, serviceCode);
            this.index.getServiceCodesRunningForDate().computeIfAbsent(serviceDate, ignored -> new TIntHashSet()).add(serviceCode);
        }
        return serviceId;
    }

    public Collection<String> getFeedIds() {
        return this.feedIds;
    }

    public Collection<Agency> getAgencies() {
        return this.agencies;
    }

    public FeedInfo getFeedInfo(String feedId) {
        return this.feedInfoForId.get(feedId);
    }

    public void addAgency(Agency agency) {
        this.invalidateIndex();
        this.agencies.add(agency);
        this.feedIds.add(agency.getId().getFeedId());
    }

    public void addFeedInfo(FeedInfo info) {
        this.invalidateIndex();
        this.feedInfoForId.put(info.getId(), info);
    }

    public ZoneId getTimeZone() {
        return this.timeZone;
    }

    public void initTimeZone(ZoneId timeZone) {
        if (timeZone == null || timeZone.equals(this.timeZone)) {
            return;
        }
        this.invalidateIndex();
        this.timeZone = ObjectUtils.requireNotInitialized(this.timeZone, timeZone);
        this.timeZoneExplicitlySet = true;
    }

    public Set<ZoneId> getAgencyTimeZones() {
        HashSet<ZoneId> ret = new HashSet<ZoneId>();
        for (Agency agency : this.agencies) {
            ret.add(agency.getTimezone());
        }
        return ret;
    }

    public Collection<Operator> getOperators() {
        return this.operators;
    }

    public void validateTimeZones() {
        Set<ZoneId> zones;
        if (!this.timeZoneExplicitlySet && (zones = this.getAgencyTimeZones()).size() > 1) {
            throw new IllegalStateException("The graph contains agencies with different time zones: %s. Please configure the one to be used in the build-config.json".formatted(zones));
        }
    }

    public ZonedDateTime getTransitServiceStarts() {
        return this.transitServiceStarts;
    }

    public ZonedDateTime getTransitServiceEnds() {
        return this.transitServiceEnds;
    }

    public Multimap<AbstractTransitEntity, Notice> getNoticesByElement() {
        return this.noticesByElement;
    }

    public void addNoticeAssignments(Multimap<AbstractTransitEntity, Notice> noticesByElement) {
        this.invalidateIndex();
        this.noticesByElement.putAll(noticesByElement);
    }

    public TransitAlertService getTransitAlertService() {
        if (this.transitAlertService == null) {
            this.transitAlertService = new DelegatingTransitAlertServiceImpl(this);
        }
        return this.transitAlertService;
    }

    public TripPattern getTripPatternForId(FeedScopedId id) {
        return this.tripPatternForId.get(id);
    }

    public Map<FeedScopedId, TripOnServiceDate> getTripOnServiceDates() {
        return this.tripOnServiceDates;
    }

    public StopLocation getStopLocationById(FeedScopedId id) {
        return this.stopModel.getStopLocation(id);
    }

    public Map<FeedScopedId, Integer> getServiceCodes() {
        return this.serviceCodes;
    }

    public Collection<PathTransfer> getTransfersByStop(StopLocation stop) {
        return this.transfersByStop.get((Object)stop);
    }

    public StopModel getStopModel() {
        return this.stopModel;
    }

    public void addTripPattern(FeedScopedId id, TripPattern tripPattern) {
        this.invalidateIndex();
        this.tripPatternForId.put(id, tripPattern);
    }

    public Collection<TripPattern> getAllTripPatterns() {
        return this.tripPatternForId.values();
    }

    public Collection<TripOnServiceDate> getAllTripOnServiceDates() {
        return this.tripOnServiceDates.values();
    }

    public GraphUpdaterManager getUpdaterManager() {
        return this.updaterManager;
    }

    public TransitLayerUpdater getTransitLayerUpdater() {
        return this.transitLayerUpdater;
    }

    public Deduplicator getDeduplicator() {
        return this.deduplicator;
    }

    public Collection<PathTransfer> getAllPathTransfers() {
        return this.transfersByStop.values();
    }

    public Collection<FlexTrip<?, ?>> getAllFlexTrips() {
        return this.flexTripsById.values();
    }

    public boolean hasTransit() {
        return this.hasTransit;
    }

    private void updateHasTransit(boolean hasTransit) {
        this.hasTransit = this.hasTransit || hasTransit;
    }

    public void setTransitLayerUpdater(TransitLayerUpdater transitLayerUpdater) {
        this.transitLayerUpdater = transitLayerUpdater;
    }

    public void mergeStopModels(StopModel newStopModel) {
        this.invalidateIndex();
        this.stopModel = this.stopModel.copy().addAll(newStopModel).build();
    }

    public void addFlexTrip(FeedScopedId id, FlexTrip<?, ?> flexTrip) {
        this.invalidateIndex();
        this.flexTripsById.put(id, flexTrip);
    }

    public void setUpdaterManager(GraphUpdaterManager updaterManager) {
        this.updaterManager = updaterManager;
    }

    public void addAllTransfersByStops(Multimap<StopLocation, PathTransfer> transfersByStop) {
        this.invalidateIndex();
        this.transfersByStop.putAll(transfersByStop);
    }

    public boolean hasFrequencyService() {
        return this.hasFrequencyService;
    }

    public void setHasFrequencyService(boolean hasFrequencyService) {
        this.hasFrequencyService = hasFrequencyService;
    }

    public boolean hasScheduledService() {
        return this.hasScheduledService;
    }

    public void setHasScheduledService(boolean hasScheduledService) {
        this.hasScheduledService = hasScheduledService;
    }

    @Nullable
    public TransitModelIndex getTransitModelIndex() {
        return this.index;
    }

    public boolean hasFlexTrips() {
        return !this.flexTripsById.isEmpty();
    }

    public FlexTrip getFlexTrip(FeedScopedId tripId) {
        return this.flexTripsById.get(tripId);
    }

    private void invalidateIndex() {
        this.index = null;
    }

    private void updateTransitFeedValidity(CalendarServiceData data, @Nullable DataImportIssueStore issueStore) {
        Instant now = Instant.now();
        HashSet<String> agenciesWithFutureDates = new HashSet<String>();
        HashSet<String> agencies = new HashSet<String>();
        this.initTimeZone();
        for (FeedScopedId sid : data.getServiceIds()) {
            agencies.add(sid.getFeedId());
            for (LocalDate sd : data.getServiceDatesForServiceId(sid)) {
                ZonedDateTime t = ServiceDateUtils.asStartOfService(sd, this.getTimeZone());
                if (t.toInstant().isAfter(now)) {
                    agenciesWithFutureDates.add(sid.getFeedId());
                }
                ZonedDateTime u = t.plusDays(1L);
                if (t.isBefore(this.transitServiceStarts)) {
                    this.transitServiceStarts = t;
                }
                if (!u.isAfter(this.transitServiceEnds)) continue;
                this.transitServiceEnds = u;
            }
        }
        if (issueStore != null) {
            for (String agency : agencies) {
                if (agenciesWithFutureDates.contains(agency)) continue;
                issueStore.add(new NoFutureDates(agency));
            }
        }
    }

    private void initTimeZone() {
        if (this.timeZone == null) {
            if (this.agencies.isEmpty()) {
                this.timeZone = ZoneId.of("GMT");
                LOG.warn("graph contains no agencies (yet); API request times will be interpreted as GMT.");
            } else {
                this.timeZone = this.getAgencyTimeZones().iterator().next();
                LOG.debug("graph time zone set to {}", (Object)this.timeZone);
            }
        }
    }
}

