/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.service;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.locationtech.jts.geom.Envelope;
import org.opentripplanner.common.geometry.HashGridSpatialIndex;
import org.opentripplanner.transit.model.site.AreaStop;
import org.opentripplanner.transit.model.site.GroupStop;
import org.opentripplanner.transit.model.site.MultiModalStation;
import org.opentripplanner.transit.model.site.RegularStop;
import org.opentripplanner.transit.model.site.Station;
import org.opentripplanner.transit.model.site.StopLocation;
import org.opentripplanner.util.lang.CollectionsView;

class StopModelIndex {
    private final HashGridSpatialIndex<RegularStop> regularStopSpatialIndex = new HashGridSpatialIndex();
    private final Map<Station, MultiModalStation> multiModalStationForStations = new HashMap<Station, MultiModalStation>();
    private final HashGridSpatialIndex<AreaStop> locationIndex = new HashGridSpatialIndex();
    private final StopLocation[] stopsByIndex = new StopLocation[StopLocation.indexCounter()];

    StopModelIndex(Collection<RegularStop> stops, Collection<AreaStop> flexStops, Collection<GroupStop> groupStops, Collection<MultiModalStation> multiModalStations) {
        CollectionsView allStops = new CollectionsView(stops, flexStops, groupStops);
        for (StopLocation stopLocation : allStops) {
            if (stopLocation instanceof RegularStop) {
                RegularStop regularStop = (RegularStop)stopLocation;
                Envelope envelope = new Envelope(stopLocation.getCoordinate().asJtsCoordinate());
                this.regularStopSpatialIndex.insert(envelope, (Object)regularStop);
            }
            this.stopsByIndex[stopLocation.getIndex()] = stopLocation;
        }
        for (MultiModalStation multiModalStation : multiModalStations) {
            for (Station childStation : multiModalStation.getChildStations()) {
                this.multiModalStationForStations.put(childStation, multiModalStation);
            }
        }
        for (AreaStop areaStop : flexStops) {
            this.locationIndex.insert(areaStop.getGeometry().getEnvelopeInternal(), (Object)areaStop);
        }
    }

    Collection<RegularStop> findRegularStops(Envelope envelope) {
        return this.regularStopSpatialIndex.query(envelope);
    }

    MultiModalStation getMultiModalStationForStation(Station station) {
        return this.multiModalStationForStations.get(station);
    }

    StopLocation stopByIndex(int index) {
        return this.stopsByIndex[index];
    }

    int stopIndexSize() {
        return this.stopsByIndex.length;
    }

    Collection<AreaStop> findAreaStops(Envelope envelope) {
        return this.locationIndex.query(envelope);
    }
}

