/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.service;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.locationtech.jts.geom.Envelope;
import org.opentripplanner.transit.model.basic.WgsCoordinate;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.site.AreaStop;
import org.opentripplanner.transit.model.site.GroupOfStations;
import org.opentripplanner.transit.model.site.GroupStop;
import org.opentripplanner.transit.model.site.MultiModalStation;
import org.opentripplanner.transit.model.site.RegularStop;
import org.opentripplanner.transit.model.site.Station;
import org.opentripplanner.transit.model.site.StopLocation;
import org.opentripplanner.transit.model.site.StopLocationsGroup;
import org.opentripplanner.transit.service.StopModelBuilder;
import org.opentripplanner.transit.service.StopModelIndex;
import org.opentripplanner.util.lang.CollectionsView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StopModel
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(StopModel.class);
    private final Map<FeedScopedId, RegularStop> regularStopById;
    private final Map<FeedScopedId, Station> stationById;
    private final Map<FeedScopedId, MultiModalStation> multiModalStationById;
    private final Map<FeedScopedId, GroupOfStations> groupOfStationsById;
    private final Map<FeedScopedId, AreaStop> areaStopById;
    private final Map<FeedScopedId, GroupStop> groupStopById;
    private final WgsCoordinate stopLocationCenter;
    private transient StopModelIndex index;

    @Inject
    public StopModel() {
        this.regularStopById = Map.of();
        this.stationById = Map.of();
        this.multiModalStationById = Map.of();
        this.groupOfStationsById = Map.of();
        this.areaStopById = Map.of();
        this.groupStopById = Map.of();
        this.stopLocationCenter = null;
        this.index = new StopModelIndex(List.of(), List.of(), List.of(), List.of());
    }

    public StopModel(StopModelBuilder builder) {
        this.regularStopById = builder.regularStopsById().asImmutableMap();
        this.stationById = builder.stationById().asImmutableMap();
        this.multiModalStationById = builder.multiModalStationById().asImmutableMap();
        this.groupOfStationsById = builder.groupOfStationById().asImmutableMap();
        this.areaStopById = builder.areaStopById().asImmutableMap();
        this.groupStopById = builder.groupStopById().asImmutableMap();
        this.stopLocationCenter = builder.calculateTransitCenter();
        this.reindex();
    }

    public static StopModelBuilder of() {
        return new StopModelBuilder();
    }

    public StopModelBuilder copy() {
        return new StopModelBuilder(this);
    }

    public RegularStop getRegularStop(FeedScopedId id) {
        return this.regularStopById.get(id);
    }

    public Collection<RegularStop> listRegularStops() {
        return this.regularStopById.values();
    }

    public Collection<RegularStop> findRegularStops(Envelope envelope) {
        return this.index.findRegularStops(envelope);
    }

    public boolean hasAreaStops() {
        return !this.areaStopById.isEmpty();
    }

    @Nullable
    public AreaStop getAreaStop(FeedScopedId id) {
        return this.areaStopById.get(id);
    }

    public Collection<AreaStop> listAreaStops() {
        return this.areaStopById.values();
    }

    public Collection<AreaStop> queryLocationIndex(Envelope envelope) {
        return this.index.findAreaStops(envelope);
    }

    public Collection<GroupStop> listGroupStops() {
        return this.groupStopById.values();
    }

    public StopLocation stopByIndex(int stopIndex) {
        return this.index.stopByIndex(stopIndex);
    }

    public int stopIndexSize() {
        return this.index.stopIndexSize();
    }

    public Optional<WgsCoordinate> stopLocationCenter() {
        return Optional.ofNullable(this.stopLocationCenter);
    }

    @Nullable
    public StopLocation getStopLocation(FeedScopedId id) {
        return (StopLocation)StopModel.getById(id, this.regularStopById, this.areaStopById, this.groupStopById);
    }

    public Collection<StopLocation> listStopLocations() {
        return new CollectionsView<StopLocation>(this.regularStopById.values(), this.areaStopById.values(), this.groupStopById.values());
    }

    @Nullable
    public Station getStationById(FeedScopedId id) {
        return this.stationById.get(id);
    }

    public Collection<Station> listStations() {
        return this.stationById.values();
    }

    @Nullable
    public MultiModalStation getMultiModalStation(FeedScopedId id) {
        return this.multiModalStationById.get(id);
    }

    public Collection<MultiModalStation> listMultiModalStations() {
        return this.multiModalStationById.values();
    }

    @Nullable
    public MultiModalStation getMultiModalStationForStation(Station station) {
        return this.index.getMultiModalStationForStation(station);
    }

    public Collection<GroupOfStations> listGroupOfStations() {
        return this.groupOfStationsById.values();
    }

    @Nullable
    public StopLocationsGroup getStopLocationsGroup(FeedScopedId id) {
        return (StopLocationsGroup)StopModel.getById(id, this.stationById, this.multiModalStationById, this.groupOfStationsById);
    }

    public Collection<StopLocationsGroup> listStopLocationGroups() {
        return new CollectionsView<StopLocationsGroup>(this.stationById.values(), this.multiModalStationById.values(), this.groupOfStationsById.values());
    }

    @Nullable
    public WgsCoordinate getCoordinateById(FeedScopedId id) {
        GroupOfStations groupOfStations = this.groupOfStationsById.get(id);
        if (groupOfStations != null) {
            return groupOfStations.getCoordinate();
        }
        MultiModalStation multiModalStation = this.multiModalStationById.get(id);
        if (multiModalStation != null) {
            return multiModalStation.getCoordinate();
        }
        Station station = this.stationById.get(id);
        if (station != null) {
            return station.getCoordinate();
        }
        StopLocation stop = this.getStopLocation(id);
        return stop == null ? null : stop.getCoordinate();
    }

    public Collection<StopLocation> findStopOrChildStops(FeedScopedId id) {
        StopLocationsGroup stops = this.getStopLocationsGroup(id);
        if (stops != null) {
            return stops.getChildStops();
        }
        StopLocation stop = this.getStopLocation(id);
        return stop == null ? List.of() : List.of(stop);
    }

    public void reindexAfterDeserialization() {
        this.reindex();
    }

    private void reindex() {
        LOG.info("Index stop model...");
        this.index = new StopModelIndex(this.regularStopById.values(), this.areaStopById.values(), this.groupStopById.values(), this.multiModalStationById.values());
        LOG.info("Index stop model complete.");
    }

    @Nullable
    @SafeVarargs
    private static <V> V getById(FeedScopedId id, Map<FeedScopedId, ? extends V> ... maps) {
        for (Map<FeedScopedId, V> map : maps) {
            V v = map.get(id);
            if (v == null) continue;
            return v;
        }
        return null;
    }
}

