/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.raptor.util;

import java.util.Comparator;
import java.util.function.IntFunction;
import org.opentripplanner.util.time.TimeUtils;

public class CompareIntArrays {
    private final String label;
    private final String aName;
    private final String bName;
    private final int unreached;
    private final IntFunction<String> mapValue;
    private final Comparator<Integer> comparator;
    private String hh = "";
    private String aValues = "";
    private String bValues = "";
    private int aLess = 0;
    private int bLess = 0;
    private int aNotReached = 0;
    private int bNotReached = 0;

    private CompareIntArrays(String label, String aName, String bName, int unreached, IntFunction<String> mapValue, Comparator<Integer> comparator) {
        this.label = label;
        this.aName = aName;
        this.bName = bName;
        this.unreached = unreached;
        this.mapValue = mapValue;
        this.comparator = comparator;
    }

    public static String compareTime(String label, String aName, int[] a, String bName, int[] b, int unreached, int[] stops, Comparator<Integer> comparator) {
        return CompareIntArrays.compare(label, aName, a, bName, b, TimeUtils::timeToStrCompact, comparator, unreached, stops);
    }

    public static String compare(String label, String aName, int[] a, String bName, int[] b, int unreached, int[] stops, Comparator<Integer> comparator) {
        return CompareIntArrays.compare(label, aName, a, bName, b, Integer::toString, comparator, unreached, stops);
    }

    private static String compare(String label, String aName, int[] a, String bName, int[] b, IntFunction<String> mapValue, Comparator<Integer> comparator, int unreached, int[] stops) {
        int size;
        CompareIntArrays s = new CompareIntArrays(label, aName, bName, unreached, mapValue, comparator);
        if (stops != null && stops.length > 0) {
            size = stops.length;
            s.compare(a, b, stops);
        } else {
            size = a.length;
            s.compareAll(a, b);
        }
        return s.result(size);
    }

    private void compare(int[] a, int[] b, int[] index) {
        for (int i : index) {
            this.addResult(i, a[i], b[i]);
            this.countDiff(a[i], b[i]);
        }
    }

    private void compareAll(int[] a, int[] b) {
        for (int i = 0; i < a.length; ++i) {
            int u = a[i];
            int v = b[i];
            if (u == v) continue;
            if (this.hh.length() < 2000) {
                this.addResult(i, u, v);
            }
            this.countDiff(a[i], b[i]);
        }
        if (this.hh.length() == 0) {
            this.hh = this.hh + "ALL STOPS";
            this.aValues = this.aValues + "  ARE";
            this.bValues = this.bValues + " EQUAL";
        }
    }

    private void countDiff(int a, int b) {
        if (a == this.unreached) {
            ++this.aNotReached;
        } else if (b == this.unreached) {
            ++this.bNotReached;
        } else {
            int c = this.comparator.compare(a, b);
            if (c < 0) {
                ++this.aLess;
            } else if (c > 0) {
                ++this.bLess;
            }
        }
    }

    private void addResult(int i, int u, int v) {
        this.hh = this.hh + String.format("%8d ", i);
        this.aValues = this.aValues + String.format("%8s ", this.toStr(u));
        this.bValues = this.bValues + String.format("%8s ", this.toStr(v));
    }

    private String toStr(int v) {
        return v == this.unreached ? "" : this.mapValue.apply(v);
    }

    private String result(int size) {
        int w = Math.max(4, Math.max(this.aName.length(), this.bName.length()));
        String f = "%-" + w + "s  %s%n";
        String result = this.label + "\n";
        result = result + String.format(f, "Stop", this.hh);
        result = result + String.format(f, this.aName, this.aValues);
        result = result + String.format(f, this.bName, this.bValues);
        if (this.diffTot() != 0) {
            result = result + String.format("Number of diffs: %d of %d, %s better: %d and not reached: %d, %s better: %d and not reached: %d.%n", this.diffTot(), size, this.aName, this.aLess, this.aNotReached, this.bName, this.bLess, this.bNotReached);
        }
        return result;
    }

    private int diffTot() {
        return this.aNotReached + this.aLess + this.bNotReached + this.bLess;
    }
}

