/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.raptor.service;

import javax.annotation.Nullable;
import org.opentripplanner.transit.raptor.api.request.RaptorProfile;
import org.opentripplanner.transit.raptor.api.request.RaptorRequest;
import org.opentripplanner.transit.raptor.api.request.RaptorRequestBuilder;
import org.opentripplanner.transit.raptor.api.transit.RaptorTransitDataProvider;
import org.opentripplanner.transit.raptor.api.transit.RaptorTripSchedule;
import org.opentripplanner.transit.raptor.api.transit.SearchDirection;
import org.opentripplanner.transit.raptor.configure.RaptorConfig;
import org.opentripplanner.transit.raptor.rangeraptor.internalapi.HeuristicSearch;
import org.opentripplanner.transit.raptor.rangeraptor.internalapi.Heuristics;
import org.opentripplanner.transit.raptor.service.DebugHeuristics;
import org.opentripplanner.transit.raptor.service.DestinationNotReachedException;
import org.opentripplanner.util.time.DurationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeuristicSearchTask<T extends RaptorTripSchedule> {
    private static final Logger LOG = LoggerFactory.getLogger(HeuristicSearchTask.class);
    private final SearchDirection direction;
    private final String name;
    private final RaptorConfig<T> config;
    private final RaptorTransitDataProvider<T> transitData;
    private boolean run = false;
    private HeuristicSearch<T> search = null;
    private RaptorRequest<T> originalRequest;
    private RaptorRequest<T> heuristicReq;

    public HeuristicSearchTask(RaptorRequest<T> request, RaptorConfig<T> config, RaptorTransitDataProvider<T> transitData) {
        this(request.searchDirection(), request.alias(), config, transitData);
        this.originalRequest = request;
    }

    public HeuristicSearchTask(SearchDirection direction, String name, RaptorConfig<T> config, RaptorTransitDataProvider<T> transitData) {
        this.direction = direction;
        this.name = name;
        this.config = config;
        this.transitData = transitData;
    }

    public String name() {
        return this.name;
    }

    public void enable() {
        this.run = true;
    }

    public boolean isEnabled() {
        return this.run;
    }

    public SearchDirection getDirection() {
        return this.direction;
    }

    @Nullable
    public Heuristics result() {
        return this.search == null ? null : this.search.heuristics();
    }

    public HeuristicSearchTask<T> withRequest(RaptorRequest<T> request) {
        this.originalRequest = request;
        return this;
    }

    public void forceRun() {
        this.enable();
        this.run();
    }

    public void debugCompareResult(HeuristicSearchTask<T> other) {
        if (!this.isEnabled() || !other.isEnabled()) {
            return;
        }
        DebugHeuristics.debug(this.name(), this.result(), other.name(), other.result(), this.originalRequest);
    }

    void run() {
        if (!this.run) {
            return;
        }
        long start = System.currentTimeMillis();
        this.createHeuristicSearchIfNotExist(this.originalRequest);
        LOG.debug("Heuristic search: {}", this.heuristicReq);
        this.search.route();
        LOG.debug("Heuristic result: {}", (Object)this.search.heuristics());
        if (!this.search.destinationReached()) {
            throw new DestinationNotReachedException();
        }
        if (LOG.isDebugEnabled()) {
            String time = DurationUtils.msToSecondsStr(System.currentTimeMillis() - start);
            LOG.debug("RangeRaptor - {} heuristic search performed in {}.", (Object)this.name, (Object)time);
        }
    }

    private void createHeuristicSearchIfNotExist(RaptorRequest<T> request) {
        if (this.search == null) {
            RaptorProfile profile = RaptorProfile.MIN_TRAVEL_DURATION_BEST_TIME;
            if (request.searchParams().constrainedTransfersEnabled()) {
                profile = RaptorProfile.MIN_TRAVEL_DURATION;
            }
            RaptorRequestBuilder<T> builder = request.mutate().clearOptimizations().profile(profile).searchDirection(this.direction);
            builder.searchParams().searchOneIterationOnly();
            builder.performanceTimers(request.performanceTimers().withNamePrefix(builder.generateAlias()));
            this.heuristicReq = builder.build();
            this.search = this.config.createHeuristicSearch(this.transitData, this.transitData.multiCriteriaCostCalculator(), this.heuristicReq);
        }
    }
}

