/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.raptor.rangeraptor.transit;

import org.opentripplanner.transit.raptor.api.transit.RaptorSlackProvider;
import org.opentripplanner.transit.raptor.rangeraptor.internalapi.SlackProvider;
import org.opentripplanner.transit.raptor.rangeraptor.internalapi.WorkerLifeCycle;

public final class SlackProviderAdapter {
    private SlackProviderAdapter() {
    }

    public static SlackProvider forwardSlackProvider(RaptorSlackProvider source, WorkerLifeCycle lifeCycle) {
        ForwardSlackProvider slackProvider = new ForwardSlackProvider(source);
        lifeCycle.onPrepareForNextRound(slackProvider::notifyNewRound);
        return slackProvider;
    }

    public static SlackProvider reverseSlackProvider(RaptorSlackProvider source, WorkerLifeCycle lifeCycle) {
        ReverseSlackProvider slackProvider = new ReverseSlackProvider(source);
        lifeCycle.onPrepareForNextRound(slackProvider::notifyNewRound);
        return slackProvider;
    }

    private static final class ForwardSlackProvider
    implements SlackProvider {
        private final RaptorSlackProvider source;
        private int transferSlack;

        private ForwardSlackProvider(RaptorSlackProvider source) {
            this.source = source;
            this.transferSlack = 0;
        }

        public void notifyNewRound(int round) {
            this.transferSlack = round < 2 ? 0 : this.source.transferSlack();
        }

        @Override
        public int boardSlack(int slackIndex) {
            return this.source.boardSlack(slackIndex) + this.transferSlack;
        }

        @Override
        public int alightSlack(int slackIndex) {
            return this.source.alightSlack(slackIndex);
        }

        @Override
        public int transferSlack() {
            return this.source.transferSlack();
        }
    }

    private static final class ReverseSlackProvider
    implements SlackProvider {
        private final RaptorSlackProvider source;
        private int transferSlack;

        private ReverseSlackProvider(RaptorSlackProvider source) {
            this.source = source;
            this.transferSlack = 0;
        }

        public void notifyNewRound(int round) {
            this.transferSlack = round < 2 ? 0 : this.source.transferSlack();
        }

        @Override
        public int boardSlack(int slackIndex) {
            return this.source.alightSlack(slackIndex) + this.transferSlack;
        }

        @Override
        public int alightSlack(int slackIndex) {
            return this.source.boardSlack(slackIndex);
        }

        @Override
        public int transferSlack() {
            return this.source.transferSlack();
        }
    }
}

