/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.raptor.rangeraptor.transit;

import gnu.trove.map.TIntObjectMap;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.opentripplanner.transit.raptor.api.request.RaptorProfile;
import org.opentripplanner.transit.raptor.api.transit.RaptorAccessEgress;
import org.opentripplanner.transit.raptor.rangeraptor.transit.AccessEgressFunctions;

public class EgressPaths {
    private final TIntObjectMap<List<RaptorAccessEgress>> pathsByStop;

    private EgressPaths(TIntObjectMap<List<RaptorAccessEgress>> pathsByStop) {
        this.pathsByStop = pathsByStop;
    }

    public TIntObjectMap<List<RaptorAccessEgress>> byStop() {
        return this.pathsByStop;
    }

    public int[] stops() {
        return this.pathsByStop.keys();
    }

    public Collection<RaptorAccessEgress> listAll() {
        return this.pathsByStop.valueCollection().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    public static EgressPaths create(Collection<RaptorAccessEgress> paths, RaptorProfile profile) {
        if (!profile.is(RaptorProfile.MULTI_CRITERIA)) {
            paths = AccessEgressFunctions.removeNoneOptimalPathsForStandardRaptor(paths);
        }
        return new EgressPaths(AccessEgressFunctions.groupByStop(paths));
    }
}

