/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.raptor.rangeraptor.transit;

import gnu.trove.map.TIntObjectMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import org.opentripplanner.transit.raptor.api.request.RaptorProfile;
import org.opentripplanner.transit.raptor.api.transit.RaptorAccessEgress;
import org.opentripplanner.transit.raptor.rangeraptor.transit.AccessEgressFunctions;

public class AccessPaths {
    private final TIntObjectMap<List<RaptorAccessEgress>> arrivedOnStreetByNumOfRides;
    private final TIntObjectMap<List<RaptorAccessEgress>> arrivedOnBoardByNumOfRides;

    private AccessPaths(TIntObjectMap<List<RaptorAccessEgress>> arrivedOnStreetByNumOfRides, TIntObjectMap<List<RaptorAccessEgress>> arrivedOnBoardByNumOfRides) {
        this.arrivedOnStreetByNumOfRides = arrivedOnStreetByNumOfRides;
        this.arrivedOnBoardByNumOfRides = arrivedOnBoardByNumOfRides;
    }

    public TIntObjectMap<List<RaptorAccessEgress>> arrivedOnStreetByNumOfRides() {
        return this.arrivedOnStreetByNumOfRides;
    }

    public TIntObjectMap<List<RaptorAccessEgress>> arrivedOnBoardByNumOfRides() {
        return this.arrivedOnBoardByNumOfRides;
    }

    public int calculateMaxNumberOfRides() {
        return Math.max(Arrays.stream(this.arrivedOnStreetByNumOfRides.keys()).max().orElse(0), Arrays.stream(this.arrivedOnBoardByNumOfRides.keys()).max().orElse(0));
    }

    public static AccessPaths create(Collection<RaptorAccessEgress> paths, RaptorProfile profile) {
        if (!profile.is(RaptorProfile.MULTI_CRITERIA)) {
            paths = AccessEgressFunctions.removeNoneOptimalPathsForStandardRaptor(paths);
        }
        return new AccessPaths(AccessEgressFunctions.groupByRound(paths, Predicate.not(RaptorAccessEgress::hasRides)), AccessEgressFunctions.groupByRound(paths, RaptorAccessEgress::hasRides));
    }
}

