/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.raptor.rangeraptor.standard.stoparrivals;

import java.util.Collection;
import java.util.List;
import org.opentripplanner.transit.raptor.api.transit.RaptorAccessEgress;
import org.opentripplanner.transit.raptor.api.transit.RaptorTransfer;
import org.opentripplanner.transit.raptor.api.transit.RaptorTripSchedule;
import org.opentripplanner.transit.raptor.rangeraptor.standard.internalapi.DestinationArrivalListener;
import org.opentripplanner.transit.raptor.rangeraptor.standard.stoparrivals.DefaultStopArrivalState;
import org.opentripplanner.util.lang.ToStringBuilder;

final class EgressStopArrivalState<T extends RaptorTripSchedule>
extends DefaultStopArrivalState<T> {
    private final int round;
    private final int stop;
    private final RaptorAccessEgress[] egressPaths;
    private final DestinationArrivalListener callback;

    EgressStopArrivalState(int stop, int round, Collection<RaptorAccessEgress> egressPaths, DestinationArrivalListener transitCallback) {
        this.round = round;
        this.stop = stop;
        this.egressPaths = egressPaths.toArray(new RaptorAccessEgress[0]);
        this.callback = transitCallback;
    }

    public int round() {
        return this.round;
    }

    public int stop() {
        return this.stop;
    }

    @Override
    public void arriveByTransit(int arrivalTime, int boardStop, int boardTime, T trip) {
        super.arriveByTransit(arrivalTime, boardStop, boardTime, trip);
        for (RaptorAccessEgress egressPath : this.egressPaths) {
            this.callback.newDestinationArrival(this.round, arrivalTime, true, egressPath);
        }
    }

    @Override
    public void transferToStop(int fromStop, int arrivalTime, RaptorTransfer transferPath) {
        super.transferToStop(fromStop, arrivalTime, transferPath);
        for (RaptorAccessEgress egressPath : this.egressPaths) {
            if (!egressPath.stopReachedOnBoard()) continue;
            this.callback.newDestinationArrival(this.round, arrivalTime, false, egressPath);
        }
    }

    @Override
    public String toString() {
        ToStringBuilder builder = ToStringBuilder.of(EgressStopArrivalState.class).addNum("stop", this.stop).addNum("round", this.round);
        this.toStringAddBody(builder);
        builder.addCol("egressPaths", List.of(this.egressPaths));
        return builder.toString();
    }
}

