/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.raptor.rangeraptor.standard.stoparrivals;

import org.opentripplanner.transit.raptor.api.transit.RaptorAccessEgress;
import org.opentripplanner.transit.raptor.api.transit.RaptorTransfer;
import org.opentripplanner.transit.raptor.api.transit.RaptorTripSchedule;
import org.opentripplanner.transit.raptor.rangeraptor.standard.stoparrivals.StopArrivalState;
import org.opentripplanner.util.lang.ToStringBuilder;

class DefaultStopArrivalState<T extends RaptorTripSchedule>
implements StopArrivalState<T> {
    static final int NOT_SET = -1;
    private int bestArrivalTime = -1;
    private int onBoardArrivalTime = -1;
    private T trip = null;
    private int boardTime = -1;
    private int boardStop = -1;
    private int transferFromStop = -1;
    private RaptorTransfer transferPath = null;

    DefaultStopArrivalState() {
    }

    @Override
    public final int time() {
        return this.bestArrivalTime;
    }

    @Override
    public final int onBoardArrivalTime() {
        return this.onBoardArrivalTime;
    }

    @Override
    public final boolean reachedOnBoard() {
        return this.onBoardArrivalTime != -1;
    }

    @Override
    public final boolean reachedOnStreet() {
        return this.arrivedByTransfer();
    }

    @Override
    public final boolean arrivedByAccessOnStreet() {
        return false;
    }

    @Override
    public final RaptorAccessEgress accessPathOnStreet() {
        throw new IllegalStateException("This class do no handle access, see AccessStopArrivalState");
    }

    @Override
    public final boolean arrivedByAccessOnBoard() {
        return false;
    }

    @Override
    public final RaptorAccessEgress accessPathOnBoard() {
        throw new IllegalStateException("This class do no handle access, see AccessStopArrivalState");
    }

    @Override
    public boolean arrivedByTransit() {
        return this.boardStop != -1;
    }

    @Override
    public final T trip() {
        return this.trip;
    }

    @Override
    public final int boardTime() {
        return this.boardTime;
    }

    @Override
    public final int boardStop() {
        return this.boardStop;
    }

    @Override
    public void arriveByTransit(int arrivalTime, int boardStop, int boardTime, T trip) {
        this.onBoardArrivalTime = arrivalTime;
        this.trip = trip;
        this.boardTime = boardTime;
        this.boardStop = boardStop;
    }

    @Override
    public final void setBestTimeTransit(int time) {
        this.bestArrivalTime = time;
        this.transferFromStop = -1;
    }

    @Override
    public final boolean arrivedByTransfer() {
        return this.transferFromStop != -1;
    }

    @Override
    public final int transferFromStop() {
        return this.transferFromStop;
    }

    @Override
    public final RaptorTransfer transferPath() {
        return this.transferPath;
    }

    @Override
    public void transferToStop(int fromStop, int arrivalTime, RaptorTransfer transferPath) {
        this.bestArrivalTime = arrivalTime;
        this.transferFromStop = fromStop;
        this.transferPath = transferPath;
    }

    public String toString() {
        return this.toStringAddBody(ToStringBuilder.of(DefaultStopArrivalState.class)).toString();
    }

    ToStringBuilder toStringAddBody(ToStringBuilder builder) {
        builder.addServiceTime("arrivalTime", this.bestArrivalTime, -1).addServiceTime("onBoardArrivalTime", this.onBoardArrivalTime, -1).addNum("boardStop", (Number)this.boardStop, -1).addServiceTime("boardTime", this.boardTime, -1).addObj("trip", this.trip == null ? null : this.trip.pattern().debugInfo()).addNum("transferFromStop", (Number)this.transferFromStop, -1);
        if (this.transferPath != null) {
            builder.addDurationSec("transfer", this.transferPath.durationInSeconds());
        }
        return builder;
    }

    void setAccessTime(int time, boolean isBestTimeOverall, boolean onBoard) {
        if (isBestTimeOverall) {
            this.bestArrivalTime = time;
            this.transferFromStop = -1;
            this.transferPath = null;
        }
        if (onBoard) {
            this.onBoardArrivalTime = time;
            this.trip = null;
            this.boardTime = -1;
            this.boardStop = -1;
        }
    }
}

