/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.raptor.rangeraptor.standard.stoparrivals;

import org.opentripplanner.transit.raptor.api.transit.RaptorAccessEgress;
import org.opentripplanner.transit.raptor.api.transit.RaptorTransfer;
import org.opentripplanner.transit.raptor.api.transit.RaptorTripSchedule;
import org.opentripplanner.transit.raptor.rangeraptor.standard.stoparrivals.DefaultStopArrivalState;
import org.opentripplanner.transit.raptor.rangeraptor.standard.stoparrivals.StopArrivalState;
import org.opentripplanner.util.lang.ToStringBuilder;

public class AccessStopArrivalState<T extends RaptorTripSchedule>
implements StopArrivalState<T> {
    private final DefaultStopArrivalState<T> delegate;
    private RaptorAccessEgress accessArriveOnStreet;
    private RaptorAccessEgress accessArriveOnBoard;

    public AccessStopArrivalState(int time, RaptorAccessEgress accessPath, boolean isOverallBestTime, DefaultStopArrivalState<T> other) {
        this.delegate = other;
        this.setAccessTime(time, accessPath, isOverallBestTime);
    }

    @Override
    public int time() {
        return this.delegate.time();
    }

    @Override
    public int onBoardArrivalTime() {
        return this.delegate.onBoardArrivalTime();
    }

    @Override
    public boolean reachedOnBoard() {
        return this.delegate.reachedOnBoard();
    }

    @Override
    public boolean reachedOnStreet() {
        return this.arrivedByAccessOnStreet() || this.arrivedByTransfer();
    }

    @Override
    public boolean arrivedByAccessOnStreet() {
        return this.accessArriveOnStreet != null;
    }

    @Override
    public RaptorAccessEgress accessPathOnStreet() {
        return this.accessArriveOnStreet;
    }

    @Override
    public boolean arrivedByAccessOnBoard() {
        return this.accessArriveOnBoard != null;
    }

    @Override
    public RaptorAccessEgress accessPathOnBoard() {
        return this.accessArriveOnBoard;
    }

    @Override
    public final boolean arrivedByTransit() {
        return this.delegate.arrivedByTransit();
    }

    @Override
    public T trip() {
        return this.delegate.trip();
    }

    @Override
    public int boardTime() {
        return this.delegate.boardTime();
    }

    @Override
    public int boardStop() {
        return this.delegate.boardStop();
    }

    @Override
    public void arriveByTransit(int arrivalTime, int boardStop, int boardTime, T trip) {
        this.accessArriveOnBoard = null;
        this.delegate.arriveByTransit(arrivalTime, boardStop, boardTime, trip);
    }

    @Override
    public void setBestTimeTransit(int time) {
        this.delegate.setBestTimeTransit(time);
    }

    @Override
    public boolean arrivedByTransfer() {
        return this.delegate.arrivedByTransfer();
    }

    @Override
    public int transferFromStop() {
        return this.delegate.transferFromStop();
    }

    @Override
    public RaptorTransfer transferPath() {
        return this.delegate.transferPath();
    }

    @Override
    public void transferToStop(int fromStop, int arrivalTime, RaptorTransfer transferPath) {
        this.accessArriveOnStreet = null;
        this.delegate.transferToStop(fromStop, arrivalTime, transferPath);
    }

    public String toString() {
        ToStringBuilder builder = ToStringBuilder.of(AccessStopArrivalState.class);
        this.delegate.toStringAddBody(builder);
        if (this.arrivedByAccessOnBoard()) {
            builder.addDurationSec("onBoard", this.accessArriveOnBoard.durationInSeconds());
        }
        if (this.arrivedByAccessOnStreet()) {
            builder.addDurationSec("onStreet", this.accessArriveOnStreet.durationInSeconds());
        }
        return builder.toString();
    }

    void setAccessTime(int time, RaptorAccessEgress access, boolean isOverallBestTime) {
        this.delegate.setAccessTime(time, isOverallBestTime, access.stopReachedOnBoard());
        if (access.stopReachedOnBoard()) {
            this.accessArriveOnBoard = access;
        } else {
            this.accessArriveOnStreet = access;
        }
    }
}

