/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.raptor.rangeraptor.path;

import org.opentripplanner.transit.raptor.api.path.Path;
import org.opentripplanner.transit.raptor.api.path.PathBuilder;
import org.opentripplanner.transit.raptor.api.transit.BoardAndAlightTime;
import org.opentripplanner.transit.raptor.api.transit.CostCalculator;
import org.opentripplanner.transit.raptor.api.transit.RaptorPathConstrainedTransferSearch;
import org.opentripplanner.transit.raptor.api.transit.RaptorSlackProvider;
import org.opentripplanner.transit.raptor.api.transit.RaptorStopNameResolver;
import org.opentripplanner.transit.raptor.api.transit.RaptorTripSchedule;
import org.opentripplanner.transit.raptor.api.view.ArrivalView;
import org.opentripplanner.transit.raptor.rangeraptor.internalapi.WorkerLifeCycle;
import org.opentripplanner.transit.raptor.rangeraptor.path.BoardAndAlightTimeSearch;
import org.opentripplanner.transit.raptor.rangeraptor.path.DestinationArrival;
import org.opentripplanner.transit.raptor.rangeraptor.path.PathMapper;
import org.opentripplanner.transit.raptor.rangeraptor.transit.TripTimesSearch;

public final class ForwardPathMapper<T extends RaptorTripSchedule>
implements PathMapper<T> {
    private final RaptorPathConstrainedTransferSearch<T> transferConstraintsSearch;
    private final RaptorSlackProvider slackProvider;
    private final CostCalculator<T> costCalculator;
    private final BoardAndAlightTimeSearch tripSearch;
    private final RaptorStopNameResolver stopNameResolver;
    private int iterationDepartureTime = -1;

    public ForwardPathMapper(RaptorPathConstrainedTransferSearch<T> transferConstraintsSearch, RaptorSlackProvider slackProvider, CostCalculator<T> costCalculator, RaptorStopNameResolver stopNameResolver, WorkerLifeCycle lifeCycle, boolean useApproximateTripTimesSearch) {
        this.transferConstraintsSearch = transferConstraintsSearch;
        this.slackProvider = slackProvider;
        this.costCalculator = costCalculator;
        this.stopNameResolver = stopNameResolver;
        this.tripSearch = ForwardPathMapper.forwardSearch(useApproximateTripTimesSearch);
        lifeCycle.onSetupIteration(this::setRangeRaptorIterationDepartureTime);
    }

    @Override
    public Path<T> mapToPath(DestinationArrival<T> destinationArrival) {
        PathBuilder<T> pathBuilder = PathBuilder.headPathBuilder(this.transferConstraintsSearch, this.slackProvider, this.costCalculator, this.stopNameResolver);
        pathBuilder.egress(destinationArrival.egressPath().egress());
        ArrivalView<T> arrival = destinationArrival.previous();
        while (true) {
            if (arrival.arrivedByTransit()) {
                BoardAndAlightTime times = this.tripSearch.find(arrival);
                pathBuilder.transit(arrival.transitPath().trip(), times);
            } else if (arrival.arrivedByTransfer()) {
                pathBuilder.transfer(arrival.transferPath().transfer(), arrival.stop());
            } else {
                if (arrival.arrivedByAccess()) break;
                throw new RuntimeException("Unknown arrival type: " + arrival.getClass().getSimpleName());
            }
            arrival = arrival.previous();
        }
        pathBuilder.access(arrival.accessPath().access());
        return pathBuilder.build(this.iterationDepartureTime);
    }

    private static BoardAndAlightTimeSearch forwardSearch(boolean useApproximateTimeSearch) {
        return useApproximateTimeSearch ? TripTimesSearch::findTripForwardSearchApproximateTime : TripTimesSearch::findTripForwardSearch;
    }

    private void setRangeRaptorIterationDepartureTime(int iterationDepartureTime) {
        this.iterationDepartureTime = iterationDepartureTime;
    }
}

